/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.chart;

import com.google.inject.Singleton;
import com.pmease.quickbuild.taskschedule.schedule.PeriodicalSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.web.chart.CachedChart;
import com.pmease.quickbuild.web.chart.ChartManager;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.time.DateUtils;

@Singleton
public class DefaultChartManager
implements ChartManager {
    private static final long CHECK_INTERVAL = 120L;
    private static final long TIME_TO_LIVE = 120L;
    private Map<String, CachedChart> charts = new ConcurrentHashMap<String, CachedChart>();

    @Override
    public void execute() {
        Date now = new Date();
        Iterator<Map.Entry<String, CachedChart>> it = this.charts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, CachedChart> entry = it.next();
            if (!entry.getValue().getTimestamp().before(DateUtils.addSeconds((Date)now, (int)-120))) continue;
            it.remove();
        }
    }

    @Override
    public Schedule getSchedule() {
        PeriodicalSchedule schedule = new PeriodicalSchedule();
        schedule.setRepeatInterval("120");
        return schedule;
    }

    @Override
    public byte[] getChartBytes(String key, int maxAccessTimes) {
        CachedChart chart = this.charts.get(key);
        if (chart != null) {
            if (chart.increaseAccessTimes() >= maxAccessTimes) {
                this.charts.remove(key);
            }
            return chart.getData();
        }
        return null;
    }

    @Override
    public void cacheChartBytes(String key, byte[] chartBytes) {
        CachedChart chart = new CachedChart();
        chart.setData(chartBytes);
        chart.setTimestamp(new Date());
        this.charts.put(key, chart);
    }
}

