/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.chart;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorUtils {
    static List<Color> COLOR_WHEEL;
    public static final Color[] DEFAULT_COLORS;
    public static final Color[] LIGHT_COLORS;

    public static Color getHeatColor(int d) {
        if (d > 100) {
            d = 100;
        }
        return Color.getHSBColor((120.0f - (float)d * 1.2f) / 360.0f, 1.0f, 1.0f);
    }

    public static String getCssHeatColor(int d) {
        return ColorUtils.toCssColor(ColorUtils.getHeatColor(d));
    }

    public static String toCssColor(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return String.format("#%02x%02x%02x", r, g, b);
    }

    static {
        ArrayList list = Lists.newArrayList();
        float h = 120.0f;
        float s = 0.83f;
        float b = 1.0f;
        for (int i = 0; i < 100; ++i) {
            list.add(Color.getHSBColor((h - (float)i * h / 100.0f) / 360.0f, s, b));
        }
        COLOR_WHEEL = ImmutableList.copyOf((Collection)list);
        DEFAULT_COLORS = new Color[]{new Color(26, 135, 213), new Color(246, 122, 54), new Color(0, 140, 80), new Color(104, 45, 140), new Color(164, 22, 35), new Color(241, 35, 51), new Color(202, 193, 65), new Color(183, 53, 144), new Color(71, 107, 214), new Color(191, 153, 48)};
        LIGHT_COLORS = new Color[]{new Color(184, 211, 234), new Color(244, 208, 179), new Color(216, 228, 176), new Color(214, 178, 210), new Color(222, 184, 171), new Color(244, 174, 174), new Color(220, 214, 167), new Color(236, 192, 216), new Color(199, 202, 210), new Color(200, 196, 186)};
    }
}

