/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;

public class ChartUtils {
    private static final String LONG_DATE_FORMAT = "MMMMM dd, yyyy";
    private static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";
    public static final Color DEFAULT_BLUE = new Color(0, 119, 204);
    public static final Color DEFAULT_YELLOW = new Color(255, 153, 0);
    public static final int DEFAULT_WIDTH = 750;
    public static final int DEFAULT_HEIGHT = 135;
    public static final String INTEGER = "INTEGER";
    public static final String FLOAT = "FLOAT";
    public static final String PERCENT = "PERCENT";
    public static final String DATE = "DATE";
    public static final String TEXT = "TEXT";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final Color[] DEFAULT_COLORS = new Color[]{new Color(26, 135, 213), new Color(255, 153, 0), new Color(82, 180, 50), new Color(237, 237, 1), new Color(115, 136, 10)};

    public static Font getFont(int size, boolean bold) {
        if (size < 10) {
            return new Font("Arial", 1, size);
        }
        return new Font("Verdana", bold ? 1 : 0, size);
    }

    public static SimpleDateFormat getLongDateFormat() {
        return new SimpleDateFormat(LONG_DATE_FORMAT);
    }

    public static SimpleDateFormat getShortDateFormat() {
        return new SimpleDateFormat(SHORT_DATE_FORMAT);
    }

    public static NumberFormat getNumberFormat(String dataType) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (dataType.equals(INTEGER)) {
            numberFormat = NumberFormat.getIntegerInstance();
        } else if (dataType.equals(FLOAT)) {
            numberFormat.setMinimumFractionDigits(3);
            numberFormat.setMaximumFractionDigits(3);
        } else if (dataType.equals(PERCENT)) {
            numberFormat = NumberFormat.getPercentInstance();
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
        }
        return numberFormat;
    }

    public static void setTitle(JFreeChart chart, String title) {
        TextTitle texttitle = new TextTitle(title, ChartUtils.getFont(14, true));
        chart.setTitle(texttitle);
    }

    public static void addSubTitle(JFreeChart chart, String subTitle) {
        TextTitle title = new TextTitle(subTitle, ChartUtils.getFont(12, true));
        chart.addSubtitle((Title)title);
    }

    public static Shape getPrimaryShape() {
        return new Ellipse2D.Float(-4.4f, -4.4f, 8.8f, 8.8f);
    }

    public static Shape getSecondaryShape() {
        return new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f);
    }

    public static Stroke getPrimaryStroke() {
        return new BasicStroke(3.2f, 2, 1);
    }

    public static Stroke getSecondaryStroke() {
        return new BasicStroke(1.5f);
    }

    public static Date getMondayOfTheDay(Date theDay) {
        Date monday = null;
        Calendar calendarDay = Calendar.getInstance();
        calendarDay.setTime(theDay);
        int day = calendarDay.get(7);
        int distance = 0;
        if (day == 2) {
            monday = calendarDay.getTime();
        } else {
            distance = day - 2;
            if (distance == -1) {
                distance = 6;
            }
            monday = calendarDay.getTime();
            monday.setTime(monday.getTime() - (long)(86400000 * distance));
        }
        return monday;
    }

    public static Date getCurrentMonday() {
        Date monday = null;
        Calendar rightNow = Calendar.getInstance();
        int day = rightNow.get(7);
        int distance = 0;
        if (day == 2) {
            monday = rightNow.getTime();
        } else {
            distance = day - 2;
            if (distance == -1) {
                distance = 6;
            }
            monday = rightNow.getTime();
            monday.setTime(monday.getTime() - (long)(86400000 * distance));
        }
        return monday;
    }

    public static void initDefaultPieChart(PiePlot plot) {
        plot.setNoDataMessage("No Data Available");
        plot.setBackgroundAlpha(0.5f);
        plot.setForegroundAlpha(0.8f);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlineVisible(false);
        plot.setCircular(true, false);
        plot.setLabelGenerator(null);
        plot.setShadowPaint((Paint)Color.WHITE);
        plot.setShadowXOffset(0.0);
        plot.setShadowYOffset(0.0);
        plot.setStartAngle(120.0);
    }
}

