/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.chart;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.chart.ChartManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChartServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/chart";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String chartKey = StringUtils.replace((String)(request.getPathInfo() != null ? request.getPathInfo() : ""), (String)"+", (String)" ").substring(1);
        String userAgent = request.getHeader("User-Agent");
        int maxAccessTimes = !(userAgent = userAgent != null ? userAgent.toLowerCase() : "").contains("msie") ? 1 : 2;
        byte[] chartBytes = ChartManager.instance.getChartBytes(chartKey, maxAccessTimes);
        if (chartBytes != null) {
            response.setContentType("image/png");
            response.setContentLength(chartBytes.length);
            try {
                ServletOutputStream out = response.getOutputStream();
                out.write(chartBytes, 0, chartBytes.length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new QuickbuildException("Requested chart already cleared from memory.");
        }
    }
}

