/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.behavior.menu;

import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.behavior.menu.Menu;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.BookmarkableTextLink;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class SettingMenuBehavior
extends MenuBehavior {
    private Long configurationId;

    public SettingMenuBehavior(Long configurationId) {
        this.configurationId = configurationId;
    }

    @Override
    protected List<MenuItem> getMenuItems() {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "general");
                return new BookmarkableTextLink(componentId, "General Setting", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "repositories");
                return new BookmarkableTextLink(componentId, "Repositories", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "steps");
                return new BookmarkableTextLink(componentId, "Steps", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "variables");
                return new BookmarkableTextLink(componentId, "Variables", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "promotions");
                return new BookmarkableTextLink(componentId, "Promotions", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "notifications");
                return new BookmarkableTextLink(componentId, "Notifications", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "aggregations");
                return new BookmarkableTextLink(componentId, "Aggregations", ConfigurationSettingPage.class, params);
            }
        });
        menuItems.addAll(this.getMenuItems(new String[0]));
        menuItems.add(new MenuItem(){

            @Override
            public Component render(String componentId) {
                PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId, "advanced");
                return new BookmarkableTextLink(componentId, "Advanced Setting", ConfigurationSettingPage.class, params);
            }
        });
        return menuItems;
    }

    private List<MenuItem> getMenuItems(final String[] categories) {
        ArrayList<MenuItemInfo> itemInfos = new ArrayList<MenuItemInfo>();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            Class<?> settingClass;
            if (!plugin.isEnabled() || (settingClass = plugin.getConfigurationSettingClass()) == null) continue;
            Object[] settingCategories = EditorHelper.getCategory(settingClass);
            int settingOrder = EditorHelper.getOrder(settingClass);
            Object itemName = null;
            if (ArrayUtils.isEquals((Object)settingCategories, (Object)categories)) {
                itemName = EditorHelper.getName(settingClass);
            } else if (settingCategories.length > categories.length && ArrayUtils.isEquals((Object)ArrayUtils.subarray((Object[])settingCategories, (int)0, (int)categories.length), (Object)categories)) {
                itemName = settingCategories[categories.length];
                settingClass = null;
            }
            if (itemName == null) continue;
            MenuItemInfo itemInfo = this.getItemInfo(itemInfos, (String)itemName);
            if (itemInfo == null) {
                itemInfo = new MenuItemInfo();
                itemInfo.setName((String)itemName);
                itemInfo.setSettingClass(settingClass);
                itemInfos.add(itemInfo);
            }
            if (itemInfo.getSettingOrder() <= settingOrder) continue;
            itemInfo.setSettingOrder(settingOrder);
        }
        Collections.sort(itemInfos, new Comparator<MenuItemInfo>(){

            @Override
            public int compare(MenuItemInfo info1, MenuItemInfo info2) {
                int result = info1.getSettingOrder() - info2.getSettingOrder();
                if (result != 0) {
                    return result;
                }
                return info1.getName().compareTo(info2.getName());
            }
        });
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (final MenuItemInfo info : itemInfos) {
            Class<?> settingClass = info.getSettingClass();
            if (settingClass != null) {
                menuItems.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        PageParameters params = ConfigurationSettingPage.params4(SettingMenuBehavior.this.configurationId);
                        for (int i = 0; i < categories.length; ++i) {
                            params.set(i + 1, (Object)categories[i].toLowerCase().replace(' ', '_'));
                        }
                        params.set(categories.length + 1, (Object)info.getName().toLowerCase().replace(' ', '_'));
                        return new BookmarkableTextLink(componentId, info.getName(), ConfigurationSettingPage.class, params);
                    }
                });
                continue;
            }
            menuItems.add(new Menu(){

                @Override
                public List<MenuItem> getItems() {
                    return SettingMenuBehavior.this.getMenuItems((String[])ArrayUtils.add((Object[])categories, (Object)info.getName()));
                }

                @Override
                public Component render(String componentId) {
                    return new Label(componentId, info.getName());
                }
            });
        }
        return menuItems;
    }

    private MenuItemInfo getItemInfo(List<MenuItemInfo> itemInfos, String name) {
        for (MenuItemInfo info : itemInfos) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    private class MenuItemInfo
    implements Serializable {
        private String name;
        private Class<?> settingClass;
        private int settingOrder = Integer.MAX_VALUE;

        private MenuItemInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getSettingClass() {
            return this.settingClass;
        }

        public void setSettingClass(Class<?> settingClass) {
            this.settingClass = settingClass;
        }

        public int getSettingOrder() {
            return this.settingOrder;
        }

        public void setSettingOrder(int settingOrder) {
            this.settingOrder = settingOrder;
        }
    }
}

