/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.behavior.menu;

import com.pmease.quickbuild.web.behavior.PopupBehavior;
import com.pmease.quickbuild.web.behavior.menu.Menu;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

class MenuPanel
extends Panel {
    public MenuPanel(String id, List<MenuItem> menuItems) {
        super(id);
        this.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"menu"))});
        this.add(new Component[]{new ListView<MenuItem>("items", menuItems){

            protected void populateItem(ListItem<MenuItem> listItem) {
                final MenuItem menuItem = (MenuItem)listItem.getModelObject();
                Component menuItemComponent = menuItem.render("item");
                listItem.add(new Component[]{menuItemComponent.setOutputMarkupId(true)});
                listItem.add(new Behavior[]{AttributeAppender.append((String)"class", (IModel)new AbstractReadOnlyModel<String>(){

                    public String getObject() {
                        String css = menuItem.getCssClass();
                        if (menuItem instanceof Menu) {
                            css = css + " sub-menu";
                        }
                        return css;
                    }
                })});
                if (menuItem instanceof Menu) {
                    final Menu menu = (Menu)menuItem;
                    PopupBehavior.Alignment alignment = new PopupBehavior.Alignment(menuItemComponent.getMarkupId(), 100, 0, 0, 0);
                    listItem.add(new Behavior[]{new MenuBehavior(){

                        @Override
                        protected List<MenuItem> getMenuItems() {
                            return menu.getItems();
                        }
                    }.hoverMode(true).alignment(alignment)});
                }
            }
        }});
        if (!menuItems.isEmpty()) {
            this.add(new Component[]{new WebMarkupContainer("placeholder").setVisible(false)});
        } else {
            this.add(new Component[]{new Label("placeholder", "No choice available").add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"p4p"))})});
        }
    }
}

