/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.behavior.menu;

import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.extensionpoint.support.TypeProvider;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.web.behavior.menu.Menu;
import com.pmease.quickbuild.web.behavior.menu.MenuBehavior;
import com.pmease.quickbuild.web.behavior.menu.MenuItem;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;

abstract class BaseTypeMenuBehavior<T extends TypeInstance>
extends MenuBehavior {
    private Class<?> typeInstanceClass;

    public BaseTypeMenuBehavior() {
        Class<?> currentClass = ((Object)((Object)this)).getClass();
        while (true) {
            Type superType = currentClass.getGenericSuperclass();
            Validate.notNull((Object)superType);
            if (superType instanceof ParameterizedType) {
                ParameterizedType parameterizedSuperType = (ParameterizedType)superType;
                for (Type each : parameterizedSuperType.getActualTypeArguments()) {
                    Class paramClass = each instanceof ParameterizedType ? (Class)((ParameterizedType)each).getRawType() : (Class)each;
                    if (!TypeInstance.class.isAssignableFrom(paramClass)) continue;
                    this.typeInstanceClass = paramClass;
                    break;
                }
                if (this.typeInstanceClass != null) break;
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    @Override
    protected final List<MenuItem> getMenuItems() {
        return this.getMenuItems(new String[0]);
    }

    private List<MenuItem> getMenuItems(final String[] categories) {
        ArrayList<MenuItemInfo> itemInfos = new ArrayList<MenuItemInfo>();
        for (TypeProvider typeProvider : PluginManager.instance.getExtensions(TypeProvider.class)) {
            Class<? extends TypeInstance> typeClass = typeProvider.getTypeClass();
            if (typeClass == null || !this.typeInstanceClass.isAssignableFrom(typeClass)) continue;
            Object[] typeCategories = EditorHelper.getCategory(typeClass);
            int typeOrder = EditorHelper.getOrder(typeClass);
            Object itemName = null;
            if (ArrayUtils.isEquals((Object)typeCategories, (Object)categories)) {
                itemName = EditorHelper.getName(typeClass);
            } else if (typeCategories.length > categories.length && ArrayUtils.isEquals((Object)ArrayUtils.subarray((Object[])typeCategories, (int)0, (int)categories.length), (Object)categories)) {
                itemName = typeCategories[categories.length];
                typeClass = null;
            }
            if (itemName == null) continue;
            MenuItemInfo itemInfo = this.getItemInfo(itemInfos, (String)itemName);
            if (itemInfo == null) {
                itemInfo = new MenuItemInfo();
                itemInfo.setName((String)itemName);
                itemInfo.setTypeClass(typeClass);
                itemInfos.add(itemInfo);
            }
            if (itemInfo.getTypeOrder() <= typeOrder) continue;
            itemInfo.setTypeOrder(typeOrder);
        }
        Collections.sort(itemInfos, new Comparator<MenuItemInfo>(){

            @Override
            public int compare(MenuItemInfo info1, MenuItemInfo info2) {
                int result = info1.getTypeOrder() - info2.getTypeOrder();
                if (result != 0) {
                    return result;
                }
                return info1.getName().compareTo(info2.getName());
            }
        });
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (final MenuItemInfo info : itemInfos) {
            final Class typeClass = info.getTypeClass();
            if (typeClass != null) {
                items.add(new MenuItem(){

                    @Override
                    public Component render(String componentId) {
                        return BaseTypeMenuBehavior.this.newMenuItemLink(componentId, info.getName(), typeClass);
                    }
                });
                continue;
            }
            items.add(new Menu(){

                @Override
                public List<MenuItem> getItems() {
                    return BaseTypeMenuBehavior.this.getMenuItems((String[])ArrayUtils.add((Object[])categories, (Object)info.getName()));
                }

                @Override
                public Component render(String componentId) {
                    return new Label(componentId, info.getName());
                }
            });
        }
        return items;
    }

    protected abstract Component newMenuItemLink(String var1, String var2, Class<T> var3);

    private MenuItemInfo getItemInfo(List<MenuItemInfo> itemInfos, String name) {
        for (MenuItemInfo info : itemInfos) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    private class MenuItemInfo
    implements Serializable {
        private String name;
        private Class<T> typeClass;
        private int typeOrder = Integer.MAX_VALUE;

        private MenuItemInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<T> getTypeClass() {
            return this.typeClass;
        }

        public void setTypeClass(Class<T> typeClass) {
            this.typeClass = typeClass;
        }

        public int getTypeOrder() {
            return this.typeOrder;
        }

        public void setTypeOrder(int typeOrder) {
            this.typeOrder = typeOrder;
        }
    }
}

