/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.behavior;

import com.pmease.quickbuild.web.behavior.SortPosition;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;

public abstract class SortBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private String sortable;
    private String handle;
    private String items;
    private String connectWith;
    private String placeholder;
    private int distance = 1;
    private String change;
    private String update;
    private String helperClass;
    private String listIndex = "ui.item.parent().index()";
    private String itemIndex = "ui.item.index()";

    public SortBehavior connectWith(String connectWith) {
        this.connectWith = connectWith;
        return this;
    }

    public SortBehavior handle(String handle) {
        this.handle = handle;
        return this;
    }

    public SortBehavior items(String items) {
        this.items = items;
        return this;
    }

    public SortBehavior placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    public SortBehavior change(String change) {
        this.change = change;
        return this;
    }

    public SortBehavior update(String update) {
        this.update = update;
        return this;
    }

    public SortBehavior helperClass(String helperClass) {
        this.helperClass = helperClass;
        return this;
    }

    public SortBehavior listIndex(String listIndex) {
        this.listIndex = listIndex;
        return this;
    }

    public SortBehavior itemIndex(String itemIndex) {
        this.itemIndex = itemIndex;
        return this;
    }

    public SortBehavior sortable(String sortable) {
        this.sortable = sortable;
        return this;
    }

    public SortBehavior distance(int distance) {
        this.distance = distance;
        return this;
    }

    protected abstract void onSort(AjaxRequestTarget var1, SortPosition var2, SortPosition var3);

    protected CharSequence getCallbackScript() {
        return this.generateCallbackScript("wicketAjaxGet('" + this.getCallbackUrl() + "&fromList=' + fromList + '&fromItem=' + fromItem + " + "'&toList=' + toList + '&toItem=' + toItem");
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }

    protected void respond(AjaxRequestTarget target) {
        int fromList = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("fromList").toInt();
        int fromItem = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("fromItem").toInt();
        int toList = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("toList").toInt();
        int toItem = RequestCycle.get().getRequest().getQueryParameters().getParameterValue("toItem").toInt();
        if (fromList != toList || fromItem != toItem) {
            this.onSort(target, new SortPosition(fromList, fromItem), new SortPosition(toList, toItem));
            for (Component component : target.getComponents()) {
                if (component == this.getComponent()) {
                    target.appendJavaScript(this.getSortScript());
                    break;
                }
                MarkupContainer container = (MarkupContainer)component;
                if (!container.contains(this.getComponent(), true)) continue;
                target.appendJavaScript(this.getSortScript());
                break;
            }
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.renderOnLoadJavaScript(this.getSortScript());
    }

    private String getSortScript() {
        StringBuffer script = new StringBuffer();
        script.append("var container=$('#" + this.getComponent().getMarkupId() + "');");
        if (this.sortable != null) {
            script.append("container=container.find('" + this.sortable + "');");
        }
        script.append("container.sortable({");
        if (this.handle != null) {
            script.append("handle:'" + this.handle + "',");
        }
        if (this.items != null) {
            script.append("items:'" + this.items + "',");
        }
        if (this.connectWith != null) {
            script.append("connectWith:'" + this.connectWith + "',");
        }
        script.append("distance:" + this.distance + ",");
        script.append("cursor:'move',");
        if (this.placeholder != null) {
            script.append("placeholder:'" + this.placeholder + "',");
        }
        if (this.helperClass != null) {
            script.append("helper:function(event,item){return item.addClass('" + this.helperClass + "');},");
        }
        script.append("start:function(event,ui){ui.item.data('fromList', " + this.listIndex + ");" + "ui.item.data('fromItem', " + this.itemIndex + ");},");
        if (this.change != null) {
            script.append("change:" + this.change + ",");
        }
        if (this.update != null) {
            script.append("update:" + this.update + ",");
        }
        script.append("stop:function(event, ui){");
        script.append("ui.item.removeClass('" + this.helperClass + "');");
        script.append("fromList=ui.item.data('fromList'); fromItem=ui.item.data('fromItem');toList=" + this.listIndex + "; toItem=" + this.itemIndex + ";" + this.getCallbackScript() + "ui.item.hide(); ui.item.show();}});");
        return script.toString();
    }
}

