/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.behavior;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.web.page.BasePage;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.repeater.RepeatingView;

public abstract class PopupBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private Component trigger;
    private Component popup;
    private Alignment alignment = new Alignment();
    private boolean hoverMode;
    private boolean showLoadIndicator = true;
    private String popupMarkupId;

    public void bind(Component component) {
        super.bind(component);
        this.trigger = component;
        this.trigger.setOutputMarkupId(true);
        this.popupMarkupId = this.trigger.getMarkupId() + "-popup";
    }

    protected abstract Component getPopup(String var1);

    public boolean getStatelessHint(Component component) {
        return false;
    }

    public PopupBehavior alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public PopupBehavior hoverMode(boolean hoverMode) {
        this.hoverMode = hoverMode;
        return this;
    }

    public PopupBehavior showLoadIndicator(boolean showLoadIndicator) {
        this.showLoadIndicator = showLoadIndicator;
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (tag.getName().equalsIgnoreCase("a")) {
            tag.put("href", (CharSequence)"javascript:void(0);");
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        String script = "if (!$('#%s')[0]) setupPopup('%s', '%s', '%s', %s, %s, '%s', %s, %s, %s, %s)";
        response.renderOnLoadJavaScript(String.format(script, this.popupMarkupId, component.getMarkupId(), this.popupMarkupId, component.getPageRelativePath(), this.hoverMode, this.showLoadIndicator, this.alignment.getTargetId() != null ? this.alignment.getTargetId() : component.getMarkupId(), this.alignment.getTargetX(), this.alignment.getTargetY(), this.alignment.getPopupX(), this.alignment.getPopupY()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPopup(AjaxRequestTarget target) {
        if (this.popup == null) {
            RepeatingView popups = BasePage.get().getPopups();
            String id = popups.newChildId();
            Context.pushComponent(this.trigger);
            try {
                this.popup = this.getPopup(id);
            }
            finally {
                Context.popComponent();
            }
            this.popup.setMetaData(BasePage.TRIGGER, this.trigger);
            this.popup.setOutputMarkupId(true);
            this.popup.setMarkupId(this.popupMarkupId);
            popups.add(new Component[]{this.popup});
            target.add(this.popup);
        }
    }

    public void closePopup(AjaxRequestTarget target) {
        target.appendJavaScript(String.format("closePopup($('#%s').parent())", this.popup.getMarkupId()));
    }

    public static void closeTopmostPopup(AjaxRequestTarget target) {
        target.appendJavaScript("closeTopmostPopup();");
    }

    public void unloadPopup() {
        if (this.popup != null) {
            this.popup.remove();
            this.popup = null;
        }
    }

    public static class Alignment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String targetId;
        private int targetX = 0;
        private int targetY = 100;
        private int popupX = 0;
        private int popupY = 0;

        public Alignment() {
        }

        public Alignment(String targetId) {
            this.targetId = targetId;
        }

        public Alignment(int targetX, int targetY, int popupX, int popupY) {
            this(null, targetX, targetY, popupX, popupY);
        }

        public Alignment(String targetId, int targetX, int targetY, int popupX, int popupY) {
            this.targetId = targetId;
            this.targetX = targetX;
            this.targetY = targetY;
            this.popupX = popupX;
            this.popupY = popupY;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public int getTargetX() {
            return this.targetX;
        }

        public void setTargetX(int targetX) {
            this.targetX = targetX;
        }

        public int getTargetY() {
            return this.targetY;
        }

        public void setTargetY(int targetY) {
            this.targetY = targetY;
        }

        public int getPopupX() {
            return this.popupX;
        }

        public void setPopupX(int popupX) {
            this.popupX = popupX;
        }

        public int getPopupY() {
            return this.popupY;
        }

        public void setPopupY(int popupY) {
            this.popupY = popupY;
        }
    }

    public static enum HorizontalAnchor {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalAnchor {
        TOP,
        CENTER,
        BOTTOM;

    }
}

