/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web.behavior;

import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ConfirmBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private IModel<String> messageModel;
    private boolean applied;

    public ConfirmBehavior(IModel<String> messageModel) {
        this.messageModel = messageModel;
    }

    public ConfirmBehavior(String message) {
        this((IModel<String>)new Model((Serializable)((Object)message)));
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
    }

    public boolean getStatelessHint(Component component) {
        return false;
    }

    public void detach(Component component) {
        super.detach(component);
        this.messageModel.detach();
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        if (!this.applied) {
            component.add(new Behavior(){
                private static final long serialVersionUID = 1L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    super.onComponentTag(component, tag);
                    if (component.isEnabled()) {
                        String message = StringUtils.formatAsHtml((String)ConfirmBehavior.this.messageModel.getObject());
                        message = StringEscapeUtils.escapeJavaScript((String)message);
                        String originScript = tag.getAttribute("onclick");
                        if (originScript == null) {
                            String href = tag.getAttribute("href");
                            originScript = href != null ? "window.location.href='" + href + "';" : String.format("$('#%s').closest('form').submit();", component.getMarkupId());
                        }
                        String amendedScript = String.format("confirmDlg('%s', function() {%s}); return false;", message, originScript);
                        amendedScript = StringUtils.replace((String)amendedScript, (String)"this.", (String)("document.getElementById('" + component.getMarkupId() + "')."));
                        tag.put("onclick", (CharSequence)amendedScript);
                    }
                }
            });
            this.applied = true;
        }
    }
}

