/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.google.inject.Singleton;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.test.TestPage;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.ServletUtils;
import com.pmease.quickbuild.web.WebSession;
import com.pmease.quickbuild.web.component.help.ScriptApiHelpPage;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.LogPage;
import com.pmease.quickbuild.web.page.RegisterPage;
import com.pmease.quickbuild.web.page.ServerSetupPage;
import com.pmease.quickbuild.web.page.ServerStartingPage;
import com.pmease.quickbuild.web.page.SignInPage;
import com.pmease.quickbuild.web.page.SignOutPage;
import com.pmease.quickbuild.web.page.WelcomePage;
import com.pmease.quickbuild.web.page.administration.DatabaseBackupPage;
import com.pmease.quickbuild.web.page.administration.EmailSettingEdit;
import com.pmease.quickbuild.web.page.administration.LicenseManagement;
import com.pmease.quickbuild.web.page.administration.ServerInformationPage;
import com.pmease.quickbuild.web.page.administration.SupportRequestPage;
import com.pmease.quickbuild.web.page.administration.SystemSettingEdit;
import com.pmease.quickbuild.web.page.administration.audit.AuditLogPage;
import com.pmease.quickbuild.web.page.administration.dashboard.DashboardAdminPage;
import com.pmease.quickbuild.web.page.administration.group.GroupManagement;
import com.pmease.quickbuild.web.page.administration.plugin.PluginManagement;
import com.pmease.quickbuild.web.page.administration.security.SecuritySettingPage;
import com.pmease.quickbuild.web.page.administration.user.UserManagement;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.build.HistoryBuildsPage;
import com.pmease.quickbuild.web.page.configuration.ChildrenPage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import com.pmease.quickbuild.web.page.configuration.StatisticsPage;
import com.pmease.quickbuild.web.page.configuration.StoragePage;
import com.pmease.quickbuild.web.page.configuration.WorkspacePage;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelinePage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import com.pmease.quickbuild.web.page.error.AccessDeniedPage;
import com.pmease.quickbuild.web.page.error.BugReportPage;
import com.pmease.quickbuild.web.page.error.ConstraintViolatedPage;
import com.pmease.quickbuild.web.page.error.ExpiredExceptionPage;
import com.pmease.quickbuild.web.page.error.ObjectNotFoundPage;
import com.pmease.quickbuild.web.page.error.QuickbuildExceptionPage;
import com.pmease.quickbuild.web.page.error.StaleExceptionPage;
import com.pmease.quickbuild.web.page.grid.GridPage;
import com.pmease.quickbuild.web.page.lite.LiteDashboardPage;
import com.pmease.quickbuild.web.page.my.MyPage;
import com.pmease.quickbuild.web.page.queue.QueuePage;
import com.pmease.quickbuild.web.page.setting.ConfigurationSettingPage;
import com.pmease.quickbuild.web.page.source.SourceDiffPage;
import com.pmease.quickbuild.web.page.source.SourceViewPage;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.IPageManagerProvider;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.page.IPageManagerContext;
import org.apache.wicket.page.PageStoreManager;
import org.apache.wicket.pageStore.AsynchronousDataStore;
import org.apache.wicket.pageStore.DefaultPageStore;
import org.apache.wicket.pageStore.DiskDataStore;
import org.apache.wicket.pageStore.IDataStore;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.protocol.https.SecureMapper;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.handler.IPageProvider;
import org.apache.wicket.request.handler.PageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.mapper.StalePageException;
import org.apache.wicket.request.resource.caching.FilenameWithVersionResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.NoOpResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.request.resource.caching.version.LastModifiedResourceVersion;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.settings.IStoreSettings;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.lang.Bytes;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.exception.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WicketConfig
extends WebApplication {
    private static final Logger logger = LoggerFactory.getLogger(WicketConfig.class);

    public ServletContext getServletContext() {
        final ServletContext sc = super.getServletContext();
        return new ServletContext(){

            public Object getAttribute(String name) {
                return sc.getAttribute(name);
            }

            public Enumeration<String> getAttributeNames() {
                return sc.getAttributeNames();
            }

            public ServletContext getContext(String uripath) {
                return sc.getContext(uripath);
            }

            public String getInitParameter(String name) {
                return sc.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return sc.getInitParameterNames();
            }

            public int getMajorVersion() {
                return sc.getMajorVersion();
            }

            public String getMimeType(String file) {
                return sc.getMimeType(file);
            }

            public int getMinorVersion() {
                return sc.getMinorVersion();
            }

            public RequestDispatcher getNamedDispatcher(String name) {
                return sc.getNamedDispatcher(name);
            }

            public String getRealPath(String path) {
                return sc.getRealPath(path);
            }

            public RequestDispatcher getRequestDispatcher(String path) {
                return sc.getRequestDispatcher(path);
            }

            public URL getResource(String path) throws MalformedURLException {
                return sc.getResource(path);
            }

            public InputStream getResourceAsStream(String path) {
                return sc.getResourceAsStream(path);
            }

            public Set<String> getResourcePaths(String path) {
                return sc.getResourcePaths(path);
            }

            public String getServerInfo() {
                return sc.getServerInfo();
            }

            public Servlet getServlet(String name) throws ServletException {
                return sc.getServlet(name);
            }

            public String getServletContextName() {
                return sc.getServletContextName();
            }

            public Enumeration<String> getServletNames() {
                return sc.getServletNames();
            }

            public Enumeration<Servlet> getServlets() {
                return sc.getServlets();
            }

            public void log(String msg) {
                sc.log(msg);
            }

            public void log(Exception exception, String msg) {
                sc.log(exception, msg);
            }

            public void log(String message, Throwable throwable) {
                sc.log(message, throwable);
            }

            public void removeAttribute(String name) {
                sc.removeAttribute(name);
            }

            public void setAttribute(String name, Object object) {
                sc.setAttribute(name, object);
            }

            public String getContextPath() {
                return sc.getContextPath();
            }

            public int getEffectiveMajorVersion() {
                return sc.getEffectiveMajorVersion();
            }

            public int getEffectiveMinorVersion() {
                return sc.getEffectiveMinorVersion();
            }

            public boolean setInitParameter(String name, String value) {
                return sc.setInitParameter(name, value);
            }

            public ServletRegistration.Dynamic addServlet(String servletName, String className) {
                return sc.addServlet(servletName, className);
            }

            public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
                return sc.addServlet(servletName, servlet);
            }

            public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
                return sc.addServlet(servletName, servletClass);
            }

            public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
                return (T)sc.createServlet(clazz);
            }

            public ServletRegistration getServletRegistration(String servletName) {
                return sc.getServletRegistration(servletName);
            }

            public Map<String, ? extends ServletRegistration> getServletRegistrations() {
                return sc.getServletRegistrations();
            }

            public FilterRegistration.Dynamic addFilter(String filterName, String className) {
                return sc.addFilter(filterName, className);
            }

            public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
                return sc.addFilter(filterName, filter);
            }

            public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
                return sc.addFilter(filterName, filterClass);
            }

            public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
                return (T)sc.createFilter(clazz);
            }

            public FilterRegistration getFilterRegistration(String filterName) {
                return sc.getFilterRegistration(filterName);
            }

            public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
                return sc.getFilterRegistrations();
            }

            public SessionCookieConfig getSessionCookieConfig() {
                return sc.getSessionCookieConfig();
            }

            public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
                sc.setSessionTrackingModes(sessionTrackingModes);
            }

            public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
                return sc.getDefaultSessionTrackingModes();
            }

            public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
                return sc.getEffectiveSessionTrackingModes();
            }

            public void addListener(String className) {
                sc.addListener(className);
            }

            public <T extends EventListener> void addListener(T t) {
                sc.addListener(t);
            }

            public void addListener(Class<? extends EventListener> listenerClass) {
                sc.addListener(listenerClass);
            }

            public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
                return (T)sc.createListener(clazz);
            }

            public JspConfigDescriptor getJspConfigDescriptor() {
                return sc.getJspConfigDescriptor();
            }

            public ClassLoader getClassLoader() {
                return sc.getClassLoader();
            }

            public void declareRoles(String ... roleNames) {
                sc.declareRoles(roleNames);
            }
        };
    }

    public Class<? extends Page> getHomePage() {
        return DashboardPage.class;
    }

    public RuntimeConfigurationType getConfigurationType() {
        if (Bootstrap.devDir != null && System.getProperty("deployment") == null) {
            return RuntimeConfigurationType.DEVELOPMENT;
        }
        return RuntimeConfigurationType.DEPLOYMENT;
    }

    public Session newSession(Request request, Response response) {
        if (Quickbuild.getInstance().isSystemReady()) {
            ServletWebRequest webRequest = (ServletWebRequest)request;
            int sessionTimeout = CacheManager.instance.getSystemSetting().getSessionTimeout();
            if (sessionTimeout < 5) {
                sessionTimeout = 5;
            }
            webRequest.getContainerRequest().getSession().setMaxInactiveInterval(sessionTimeout);
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request.getContainerRequest();
        WebSession session = new WebSession(request);
        session.setCreatedByHttps(ServletUtils.isSecureRequest(servletRequest));
        return session;
    }

    public IProvider<IExceptionMapper> getExceptionMapperProvider() {
        return new IProvider<IExceptionMapper>(){

            public IExceptionMapper get() {
                return new IExceptionMapper(){

                    public IRequestHandler map(Exception e) {
                        logger.error("Error handling wicket request.", (Throwable)e);
                        AccessDeniedException converted = ExceptionUtils.extractException(e, AccessDeniedException.class);
                        if (converted != null) {
                            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new AccessDeniedPage(converted)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                        }
                        converted = ExceptionUtils.extractException(e, ConstraintViolationException.class);
                        if (converted != null) {
                            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new ConstraintViolatedPage((ConstraintViolationException)converted)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                        }
                        converted = ExceptionUtils.extractException(e, ObjectNotFoundException.class);
                        if (converted != null) {
                            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new ObjectNotFoundPage((ObjectNotFoundException)converted)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                        }
                        converted = ExceptionUtils.extractException(e, QuickbuildException.class);
                        if (converted != null) {
                            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new QuickbuildExceptionPage((QuickbuildException)converted)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                        }
                        if (e instanceof PageExpiredException) {
                            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new ExpiredExceptionPage((PageExpiredException)e)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                        }
                        if (e instanceof StalePageException) {
                            return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new StaleExceptionPage((StalePageException)e)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                        }
                        Context.clear();
                        WebSession.get().clearData();
                        return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new BugReportPage(e)), RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT);
                    }
                };
            }
        };
    }

    public void init() {
        this.getAjaxRequestTargetListeners().add((Object)new AjaxRequestTarget.IListener(){

            @Override
            public void onBeforeRespond(Map<String, Component> map, AjaxRequestTarget target) {
                boolean hasGlobalFeedback = false;
                for (FeedbackMessage each : Session.get().getFeedbackMessages()) {
                    if (each.getReporter() != null) continue;
                    hasGlobalFeedback = true;
                }
                if (hasGlobalFeedback) {
                    target.add(new Component[]{((BasePage)target.getPage()).getGlobalFeedbackPanel()});
                    target.appendJavaScript("showGlobalFeedback();");
                }
            }

            @Override
            public void onAfterRespond(Map<String, Component> map, AjaxRequestTarget.IJavaScriptResponse response) {
            }
        });
        this.setPageManagerProvider(new IPageManagerProvider(){

            public IPageManager get(IPageManagerContext pageManagerContext) {
                IStoreSettings storeSettings = WicketConfig.this.getStoreSettings();
                Bytes maxSizePerSession = storeSettings.getMaxSizePerSession();
                File fileStoreFolder = storeSettings.getFileStoreFolder();
                Object dataStore = new DiskDataStore(WicketConfig.this.getName(), fileStoreFolder, maxSizePerSession);
                if (storeSettings.isAsynchronous()) {
                    int capacity = storeSettings.getAsynchronousQueueCapacity();
                    dataStore = new AsynchronousDataStore((IDataStore)dataStore, capacity);
                }
                int inmemoryCacheSize = WicketConfig.this.getStoreSettings().getInmemoryCacheSize();
                ISerializer pageSerializer = WicketConfig.this.getFrameworkSettings().getSerializer();
                DefaultPageStore pageStore = new DefaultPageStore(pageSerializer, (IDataStore)dataStore, inmemoryCacheSize){

                    public void storePage(String sessionId, IManageablePage page) {
                        if (page instanceof BasePage) {
                            BasePage basePage = (BasePage)page;
                            if (basePage.getRequest() == null) {
                                super.storePage(sessionId, page);
                                return;
                            }
                            String action = basePage.getRequest().getRequestParameters().getParameterValue("action").toString();
                            if (!"ajaxRefresh".equals(action) || basePage.isDirty()) {
                                super.storePage(sessionId, page);
                                return;
                            }
                        } else {
                            super.storePage(sessionId, page);
                        }
                    }
                };
                return new PageStoreManager(WicketConfig.this.getName(), (IPageStore)pageStore, pageManagerContext);
            }
        });
        if (this.usesDeploymentConfig()) {
            CachingResourceVersion version = new CachingResourceVersion((IResourceVersion)new LastModifiedResourceVersion());
            this.getResourceSettings().setCachingStrategy((IResourceCachingStrategy)new FilenameWithVersionResourceCachingStrategy((IResourceVersion)version));
        } else {
            this.getResourceSettings().setCachingStrategy((IResourceCachingStrategy)new NoOpResourceCachingStrategy());
        }
        this.getSecuritySettings().getAuthenticationStrategy();
        this.getMarkupSettings().setStripComments(true);
        this.getMarkupSettings().setStripWicketTags(true);
        this.getStoreSettings().setFileStoreFolder(new File(Bootstrap.getTempDir(), "sessions"));
        this.getStoreSettings().setMaxSizePerSession(Bytes.megabytes((long)50L));
        this.mountPage("/register", RegisterPage.class);
        this.mountPage("/dashboard", DashboardPage.class);
        this.mountPage("/build", BuildPage.class);
        this.mountPage("/source/view", SourceViewPage.class);
        this.mountPage("/source/diff", SourceDiffPage.class);
        this.mountPage("/lite", LiteDashboardPage.class);
        this.mountPage("/signin", SignInPage.class);
        this.mountPage("/signout", SignOutPage.class);
        this.mountPage("/statistics", StatisticsPage.class);
        this.mountPage("/history", HistoryBuildsPage.class);
        this.mountPage("/pipeline", PipelinePage.class);
        this.mountPage("/children", ChildrenPage.class);
        this.mountPage("/log", LogPage.class);
        this.mountPage("/grid", GridPage.class);
        this.mountPage("/queue", QueuePage.class);
        this.mountPage("/overview", ConfigurationOverview.class);
        this.mountPage("/workspace", WorkspacePage.class);
        this.mountPage("/storage", StoragePage.class);
        this.mountPage("/settings", ConfigurationSettingPage.class);
        this.mountPage("/settings/system", SystemSettingEdit.class);
        this.mountPage("/settings/email", EmailSettingEdit.class);
        this.mountPage("/settings/security", SecuritySettingPage.class);
        this.mountPage("/settings/audit", AuditLogPage.class);
        this.mountPage("/settings/dashboards", DashboardAdminPage.class);
        this.mountPage("/users", UserManagement.class);
        this.mountPage("/groups", GroupManagement.class);
        this.mountPage("/plugins", PluginManagement.class);
        this.mountPage("/backup", DatabaseBackupPage.class);
        this.mountPage("/license", LicenseManagement.class);
        this.mountPage("/server_info", ServerInformationPage.class);
        this.mountPage("/support_request", SupportRequestPage.class);
        this.mountPage("/setup", ServerSetupPage.class);
        this.mountPage("/starting", ServerStartingPage.class);
        this.mountPage("/welcome", WelcomePage.class);
        this.mountPage("/my", MyPage.class);
        this.mountPage("/script_api", ScriptApiHelpPage.class);
        this.mountPage("/test", TestPage.class);
        if (Bootstrap.getSSLPort() != 0 && Bootstrap.getPort() != 0) {
            this.setRootRequestMapper(new SecureMapper(this.getRootRequestMapper()));
        }
    }
}

