/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.web.component.StatefulPanel;
import com.pmease.quickbuild.web.component.configuration.ConfigurationTreeState;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.request.Request;
import org.apache.wicket.util.string.PrependingStringBuffer;

public class WebSession
extends org.apache.wicket.protocol.http.WebSession {
    private ConfigurationTreeState configurationTreeViewState = new ConfigurationTreeState();
    private ConfigurationTreeState configurationChooserState = new ConfigurationTreeState();
    private Long userId;
    private Long activeDashboardId;
    private boolean ignoreAuthenticationHeaders = false;
    private boolean availabeStepsCollapsed = false;
    private Map<String, Serializable> data = new HashMap<String, Serializable>();
    private Map<Integer, Date> lastRefreshDates = new HashMap<Integer, Date>();
    private boolean createdByHttps;
    private User.SearchFor searchFor;

    public WebSession(Request request) {
        super(request);
    }

    public boolean isIgnoreAuthenticationHeaders() {
        return this.ignoreAuthenticationHeaders;
    }

    public ConfigurationTreeState getConfigurationTreeViewState() {
        return this.configurationTreeViewState;
    }

    public ConfigurationTreeState getConfigurationChooserState() {
        return this.configurationChooserState;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public static WebSession get() {
        return (WebSession)org.apache.wicket.protocol.http.WebSession.get();
    }

    public void clearData() {
        this.data.clear();
    }

    public Map<String, Serializable> getData() {
        return this.data;
    }

    private String getStateKey(StatefulPanel<?> panel) {
        Page page = panel.getPage();
        if (page == null) {
            throw new QuickbuildException("State key can not be determined since the panel has not been added to page yet. This error normally happens when you get/set state in panel constructor, and you will need to move these logic into StatePanel's onInitialize() method.");
        }
        PrependingStringBuffer buffer = new PrependingStringBuffer(32);
        for (MarkupContainer c = panel; c != null; c = c.getParent()) {
            if (buffer.length() > 0) {
                buffer.prepend(':');
            }
            if (c instanceof Page) {
                buffer.prepend(c.getClass().getName());
                continue;
            }
            buffer.prepend(c.getId());
        }
        return buffer.toString();
    }

    public Serializable getState(StatefulPanel<?> panel) {
        return this.getData().get(this.getStateKey(panel));
    }

    public void setState(StatefulPanel<?> panel, Serializable state) {
        this.getData().put(this.getStateKey(panel), state);
    }

    public boolean isCreatedByHttps() {
        return this.createdByHttps;
    }

    public void setCreatedByHttps(boolean createdByHttps) {
        this.createdByHttps = createdByHttps;
    }

    public boolean isAvailabeStepsCollapsed() {
        return this.availabeStepsCollapsed;
    }

    public void setAvailabeStepsCollapsed(boolean availabeStepsCollapsed) {
        this.availabeStepsCollapsed = availabeStepsCollapsed;
    }

    public Map<Integer, Date> getLastRefreshDates() {
        return this.lastRefreshDates;
    }

    public Long getActiveDashboardId() {
        User user;
        if (this.activeDashboardId == null && (user = Context.getUser()) != null && !user.getFavoriteDashboardIds().isEmpty()) {
            this.activeDashboardId = user.getFavoriteDashboardIds().get(0);
        }
        return this.activeDashboardId;
    }

    public User.SearchFor getSearchFor() {
        User user;
        if (this.searchFor == null && (user = Context.getUser()) != null) {
            this.searchFor = user.getSearchFor();
        }
        return this.searchFor;
    }

    public void setSearchFor(User.SearchFor searchFor) {
        this.searchFor = searchFor;
        User user = Context.getUser();
        if (user != null) {
            user.setSearchFor(searchFor);
            UserManager.instance.save(user);
        }
    }

    public void setActiveDashboardId(Long activeDashboardId) {
        this.activeDashboardId = activeDashboardId;
        User user = Context.getUser();
        if (user != null) {
            user.getFavoriteDashboardIds().remove(activeDashboardId);
            user.getFavoriteDashboardIds().add(0, activeDashboardId);
            UserManager.instance.save(user);
        }
    }

    public void logout() {
        this.userId = null;
        this.configurationChooserState = new ConfigurationTreeState();
        this.configurationTreeViewState = new ConfigurationTreeState();
        this.activeDashboardId = null;
        this.availabeStepsCollapsed = false;
        this.ignoreAuthenticationHeaders = true;
        this.data.clear();
        this.lastRefreshDates.clear();
        this.createdByHttps = false;
        this.searchFor = null;
    }
}

