/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.google.inject.Inject;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.AccessLogger;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class RssFeedServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/rss_feed";
    @Inject
    private ConfigurationManager configurationManager;
    @Inject
    private BuildManager buildManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        AccessLogger.log(request, null);
        String[] fields = StringUtils.split((String)(request.getPathInfo() != null ? request.getPathInfo() : ""), (String)"/");
        Configuration configuration = (Configuration)this.configurationManager.load(Long.valueOf(fields[0]));
        Build.Status status = null;
        if (fields.length == 2) {
            status = Build.Status.valueOf(fields[1].toUpperCase());
        }
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        if (status != null) {
            feed.setTitle(status.name().toLowerCase() + " builds of " + configuration);
        } else {
            feed.setTitle("builds of " + configuration);
        }
        String url = Quickbuild.getInstance().getUrl() + "/history/" + configuration.getId();
        if (status != null) {
            url = url + "/" + status.name().toLowerCase();
        }
        feed.setLink(url);
        if (status != null) {
            feed.setDescription("This feed lists recent " + status.name().toLowerCase() + " builds of configuration " + configuration + ".");
        } else {
            feed.setDescription("This feed lists recent bulids of configuration " + configuration + ".");
        }
        SearchCriteria criteria = new SearchCriteria();
        ArrayList<Object> criterions = new ArrayList<Object>();
        criterions.add(Restrictions.eq((String)"configuration", (Object)configuration));
        if (status != null) {
            criterions.add(Restrictions.eq((String)"status", (Object)((Object)status)));
        }
        criterions.add(Restrictions.between((String)"statusDate", (Object)new Date(System.currentTimeMillis() - 86400000L), (Object)new Date()));
        criteria.setOrders(new Order[]{Order.desc((String)"id")});
        criteria.setCriterions(criterions.toArray(new Criterion[criterions.size()]));
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (Build build : this.buildManager.search(criteria, 0, 0)) {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(build.getVersion());
            entry.setLink(build.getUrl());
            entry.setPublishedDate(build.getStatusDate());
            SyndContentImpl content = new SyndContentImpl();
            content.setType("text/html");
            StringBuffer buffer = new StringBuffer();
            buffer.append("ID: " + build.getId() + "<br>");
            buffer.append("Status: " + build.getStatus().name().toLowerCase() + "<br>");
            buffer.append("Triggered By: " + build.getRequesterName() + "<br>");
            if (build.getDuration() != null) {
                buffer.append("Duration: " + DateUtils.formatDuration(build.getDuration()) + "<br>");
            }
            buffer.append("Begin Date: " + DateUtils.formatDateTime(build.getBeginDate()) + "<br>");
            content.setValue(buffer.toString());
            entry.setDescription((SyndContent)content);
            entries.add(entry);
        }
        feed.setEntries(entries);
        response.setContentType("application/xml;charset=UTF-8");
        try {
            new SyndFeedOutput().output((SyndFeed)feed, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        finally {
            try {
                response.getWriter().close();
            }
            catch (IOException e) {}
        }
    }
}

