/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.pmease.quickbuild.AuthenticationException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.web.AccessLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.http.WicketServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainServlet
extends WicketServlet {
    private static final Logger logger = LoggerFactory.getLogger(MainServlet.class);
    private static final ThreadLocal<MainServlet> current = new ThreadLocal();
    @Inject
    private WicketFilter wicketFilter;
    @Inject
    private MetricsManager metricsManager;

    public String getServletName() {
        return "quickbuild";
    }

    protected WicketFilter newWicketFilter() {
        return this.wicketFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block19: {
            String requestPath;
            String string = requestPath = request.getPathInfo() != null ? request.getPathInfo() : "";
            if (requestPath.startsWith("/service/node/") || requestPath.startsWith("/file_transfer/") || requestPath.startsWith("/download/") || requestPath.startsWith("/batch_download/") || requestPath.startsWith("/chart/") || requestPath.startsWith("/service/connect/") || requestPath.startsWith("/agent_update/") || requestPath.startsWith("/service/server/") || requestPath.startsWith("/rest/") || requestPath.startsWith("/log_request/") || requestPath.startsWith("/rss_feed/")) {
                response.sendError(503, "Server is not ready, please retry later.");
                return;
            }
            HttpSession httpSession = request.getSession(true);
            Lock lock = LockUtils.lock("session:" + httpSession.getId());
            current.set(this);
            long time = System.currentTimeMillis();
            try {
                if (Quickbuild.getInstance().isSystemReady()) {
                    SessionManager.openSession();
                    try {
                        Context.detectUserTimeZone(request);
                        if (requestPath.startsWith("/lite")) {
                            try {
                                String authorizationHeader = request.getHeader("Authorization");
                                if (authorizationHeader != null) {
                                    request.getSession(true).setAttribute("Authorization", (Object)authorizationHeader);
                                }
                                Context.setUser(SecurityHelper.authenticate(request, response));
                            }
                            catch (AuthenticationException e) {
                                PrintWriter writer = response.getWriter();
                                writer.println("<div style='color:red;'>Failed to authenticate user: " + e.getMessage());
                                writer.println("Please edit preferences to correct user name and password, then close and re-open this window.</div>");
                                writer.flush();
                            }
                            catch (Exception e) {
                                logger.error("Error authenticating user.", (Throwable)e);
                                PrintWriter writer = response.getWriter();
                                writer.println("<div style='color:red;'>Error authenticating user. Check system log for details.</div>");
                                writer.flush();
                            }
                            AccessLogger.log(request, Context.getUser());
                            super.service(request, response);
                            break block19;
                        }
                        try {
                            Context.setUser(SecurityHelper.authenticate(request, response));
                        }
                        catch (Exception e) {
                            logger.error("Error authenticating user.", (Throwable)e);
                        }
                        AccessLogger.log(request, Context.getUser());
                        String userAgent = request.getHeader("User-Agent").toLowerCase();
                        if (userAgent.contains("microsoft office") || userAgent.contains("ms-office")) {
                            response.setStatus(200);
                        } else {
                            super.service(request, response);
                        }
                        break block19;
                    }
                    finally {
                        Context.clearUserTimeZone();
                        Context.setUser(null);
                        SessionManager.closeSession();
                    }
                }
                if (requestPath.startsWith("/lite")) {
                    response.sendError(503, "Server is not ready, please retry later.");
                } else {
                    AccessLogger.log(request, Context.getUser());
                    super.service(request, response);
                }
            }
            finally {
                current.set(null);
                lock.unlock();
                this.metricsManager.webRequestProcessed(System.currentTimeMillis() - time);
            }
        }
    }

    public static MainServlet get() {
        return current.get();
    }
}

