/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.BuildLogEntryEx;
import com.pmease.quickbuild.log.LiveLog;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.web.AccessLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRequestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(LogRequestServlet.class);
    public static final String SERVLET_PATH = "/log_request";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block23: {
            SessionManager.openSession();
            try {
                String requestPath;
                Context.detectUserTimeZone(request);
                Context.setUser(SecurityHelper.authenticate(request, response));
                AccessLogger.log(request, Context.getUser());
                response.setContentType("text/plain");
                ServletOutputStream servletOut = response.getOutputStream();
                String string = requestPath = request.getPathInfo() != null ? request.getPathInfo() : "";
                if (requestPath.equals("/live")) {
                    HashMap<String, Object> map = (HashMap<String, Object>)objectMapper.readValue((InputStream)request.getInputStream(), Map.class);
                    Long buildId = ((Integer)map.get("buildId")).longValue();
                    Boolean showStep = (Boolean)map.get("showStep");
                    Map fromIndexes = (Map)map.get("fromIndexes");
                    String stepPathStr = (String)map.get("stepPath");
                    StepPath stepPath = StringUtils.isNotBlank((String)stepPathStr) ? StepPath.fromString(stepPathStr) : null;
                    logger.trace("Requesting live log of build id: " + buildId);
                    Build build = BuildEngine.instance.getBuild(buildId);
                    if (build == null) {
                        build = (Build)BuildManager.instance.load(buildId);
                    }
                    if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_BUILD_LOG.name())) {
                        throw new AccessDeniedException("Access denied when requesting live log.");
                    }
                    HashSet<String> nodeAddresses = new HashSet<String>();
                    nodeAddresses.add(Grid.instance.getLocalNode().getAddress());
                    Build build2 = build;
                    synchronized (build2) {
                        for (Step step : build.getSteps()) {
                            nodeAddresses.add(step.getNodeAddress());
                        }
                    }
                    List<BuildLogEntryEx> entries = new ArrayList();
                    for (String nodeAddress : nodeAddresses) {
                        logger.trace("Requesting live log from node: " + nodeAddress);
                        GridNode node = Grid.instance.getNode(nodeAddress);
                        if (node == null) continue;
                        Integer fromIndex = (Integer)fromIndexes.get(nodeAddress);
                        if (fromIndex == null) {
                            fromIndex = 0;
                        }
                        long serverNanosBeforeCalling = System.nanoTime();
                        long nodeNanos = node.getNodeService().getNodeNanos();
                        long serverNanosAfterCalling = System.nanoTime();
                        long nanoAhead = (serverNanosBeforeCalling + serverNanosAfterCalling) / 2L - nodeNanos;
                        LiveLog liveLog = node.getNodeService().getLiveLog(buildId, stepPath, fromIndex);
                        fromIndexes.put(nodeAddress, liveLog.getStartIndex());
                        for (BuildLogEntryEx entry : liveLog.getEntries()) {
                            if (node.isServer()) {
                                BuildLogEntryEx copy = new BuildLogEntryEx(entry);
                                copy.setNanos(copy.getNanos() + nanoAhead);
                                entries.add(copy);
                                continue;
                            }
                            entry.setNanos(entry.getNanos() + nanoAhead);
                            entries.add(entry);
                        }
                    }
                    logger.trace("Requested live log entries: " + entries.size());
                    Collections.sort(entries, new Comparator<BuildLogEntryEx>(){

                        @Override
                        public int compare(BuildLogEntryEx entry1, BuildLogEntryEx entry2) {
                            if (entry1.getNanos() < entry2.getNanos()) {
                                return -1;
                            }
                            return 1;
                        }
                    });
                    map = new HashMap<String, Object>();
                    if (entries.size() > 10000) {
                        map.put("truncated", "true");
                        entries = entries.subList(entries.size() - 10000, entries.size());
                    }
                    StringBuilder logContent = new StringBuilder();
                    for (BuildLogEntryEx entry : entries) {
                        if (entry.getStepPath() != null) {
                            Step step = build.getStep(entry.getStepPath());
                            if (step != null) {
                                logContent.append(step.renderLogAsHtml(entry, showStep));
                                continue;
                            }
                            logContent.append(entry.renderAsHtml(showStep));
                            continue;
                        }
                        logContent.append(entry.renderAsHtml(showStep));
                    }
                    map.put("fromIndexes", fromIndexes);
                    map.put("logContent", logContent);
                    if (stepPath == null && build.isFinished() || stepPath != null && build.getStep(stepPath).isFinished()) {
                        map.put("finished", "true");
                    }
                    String json = objectMapper.writeValueAsString(map);
                    response.setContentType("application/json");
                    response.setContentLength(json.length());
                    servletOut.print(json);
                    break block23;
                }
                if (requestPath.equals("/render")) {
                    Log log = Log.fromString(request.getParameter("log"));
                    Boolean showStep = Boolean.valueOf(request.getParameter("showStep"));
                    InputStream in = null;
                    try {
                        int bytesRead;
                        in = log.getHtmlInputStream(showStep);
                        byte[] data = new byte[65536];
                        while ((bytesRead = in.read(data)) != -1) {
                            servletOut.write(data, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    break block23;
                }
                throw new QuickbuildException("Invalid log request url.");
            }
            finally {
                Context.setUser(null);
                Context.clearUserTimeZone();
                SessionManager.closeSession();
            }
        }
    }
}

