/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.google.inject.Inject;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.log.BuildLog;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.ServletUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.AccessLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ZipFileSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends HttpServlet {
    public static final String SERVLET_PATH = "/download";
    private static final Logger logger = LoggerFactory.getLogger(DownloadServlet.class);
    @Inject
    private BuildManager buildManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (Bootstrap.isServer()) {
            long time = System.currentTimeMillis();
            try {
                Build build;
                Context.setUser(SecurityHelper.authenticate(request, response));
                AccessLogger.log(request, Context.getUser());
                String requestPath = request.getPathInfo() != null ? request.getPathInfo() : "";
                String[] splits = StringUtils.splitAndTrim(requestPath, "/").toArray(new String[0]);
                if (splits.length < 1 || requestPath.contains("..")) {
                    throw new QuickbuildException("Invalid download url!");
                }
                String mainPath = splits[0];
                if (mainPath.equals("buildagent.zip") || mainPath.equals("buildagent.tar.gz")) {
                    if (!SecurityHelper.isAdmin()) {
                        SecurityHelper.respondWithAccessDenied(response);
                    }
                    ServletUtils.serve(DownloadServlet.packageAgent(mainPath), "application/octet-stream", mainPath, response);
                }
                if (mainPath.equals("useragent.zip") || mainPath.equals("useragent.tar.gz")) {
                    if (!SecurityHelper.isAgentAllowed()) {
                        SecurityHelper.respondWithAccessDenied(response);
                    }
                    ServletUtils.serve(DownloadServlet.packageAgent(mainPath), "application/octet-stream", mainPath, response);
                }
                String filePath = "";
                for (int i = 1; i < splits.length; ++i) {
                    filePath = filePath + "/" + splits[i];
                }
                if (mainPath.indexOf(".") == -1) {
                    build = (Build)this.buildManager.load(Long.valueOf(mainPath));
                } else {
                    build = this.buildManager.get(mainPath);
                    if (build == null) {
                        throw new QuickbuildException("Can not find build named '" + mainPath + "'.");
                    }
                }
                boolean showStep = false;
                String showStepParam = request.getParameter("showStep");
                if (showStepParam != null) {
                    showStep = Boolean.valueOf(showStepParam);
                }
                String stepParam = request.getParameter("step");
                if (filePath.equals("/log")) {
                    if (!SecurityHelper.hasPermission(build.getConfiguration())) {
                        SecurityHelper.respondWithAccessDenied(response);
                    }
                    InputStream in = null;
                    if (stepParam == null) {
                        response.setHeader("Content-Disposition", "attachment;filename=Build-Log.txt");
                    } else {
                        response.setHeader("Content-Disposition", "attachment;filename=Step-Log.txt");
                    }
                    String clientLineSeparator = ServletUtils.getLineSeparator(request);
                    try {
                        int bytesRead;
                        BuildLog log = new BuildLog(build.getId(), stepParam != null ? StepPath.fromString(stepParam) : null);
                        in = ((Log)log).getTextInputStream(clientLineSeparator, showStep);
                        byte[] data = new byte[65536];
                        while ((bytesRead = in.read(data)) != -1) {
                            response.getOutputStream().write(data, 0, bytesRead);
                        }
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(in);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)in);
                }
                ArtifactStorage artifactStorage = build.getConfiguration().findArtifactStorage();
                if (!(artifactStorage instanceof ServerArtifactStorage) && filePath.startsWith("/artifacts")) {
                    try {
                        response.sendRedirect(artifactStorage.getUrl(build, filePath));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_ARTIFACTS.name()) || build.isRecommended() && SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_RECOMMENDED_ARTIFACTS.name())) {
                    File file = new File(build.getPublishDir(), filePath);
                    ServletUtils.serve(file, this.getServletContext().getMimeType(file.getName()), response);
                }
                SecurityHelper.respondWithAccessDenied(response);
            }
            finally {
                Context.setUser(null);
                MetricsManager.instance.downloadRequestProcessed(System.currentTimeMillis() - time);
            }
        } else {
            Build build;
            String requestPath = request.getPathInfo() != null ? request.getPathInfo() : "";
            String[] splits = StringUtils.splitAndTrim(requestPath, "/").toArray(new String[0]);
            if (splits.length < 1 || requestPath.contains("..")) {
                throw new QuickbuildException("Invalid download url!");
            }
            String mainPath = splits[0];
            String filePath = "";
            for (int i = 1; i < splits.length; ++i) {
                filePath = filePath + "/" + splits[i];
            }
            if (mainPath.indexOf(".") == -1) {
                build = (Build)this.buildManager.load(Long.valueOf(mainPath));
            } else {
                build = this.buildManager.get(mainPath);
                if (build == null) {
                    throw new QuickbuildException("Can not find build named '" + mainPath + "'.");
                }
            }
            String accessToken = request.getParameter("token");
            if (accessToken != null && request.getHeader("Authorization") == null) {
                Pair<User, Date> userAndDate = SecurityHelper.parseAccessToken(accessToken);
                if (userAndDate.getSecond().before(new Date())) {
                    logger.warn("Access token is no longer valid, sending re-authentication request...");
                    SecurityHelper.respondWithAccessDenied(response);
                } else {
                    Long userId = userAndDate.getFirst().getId();
                    if (!Quickbuild.getServerService().hasPermission(userId, build.getConfiguration().getId(), null)) {
                        SecurityHelper.respondWithAccessDenied(response);
                    } else if (Quickbuild.getServerService().hasPermission(userId, build.getConfiguration().getId(), ConfigurationPermission.ACCESS_ARTIFACTS.name())) {
                        File file = new File(build.getPublishDir(), filePath);
                        ServletUtils.serve(file, this.getServletContext().getMimeType(file.getName()), response);
                    } else {
                        SecurityHelper.respondWithAccessDenied(response);
                    }
                }
            } else {
                String userName = null;
                String password = null;
                String authorizationHeader = request.getHeader("Authorization");
                if (authorizationHeader != null) {
                    String token = StringUtils.substringAfter((String)authorizationHeader, (String)" ");
                    token = new String(Base64.decodeBase64((byte[])token.getBytes()));
                    userName = StringUtils.substringBefore((String)token, (String)":");
                    password = StringUtils.substringAfter((String)token, (String)":");
                }
                if (!Quickbuild.getServerService().hasPermission(userName, password, build.getConfiguration().getId(), null)) {
                    SecurityHelper.respondWithAccessDenied(response);
                } else if (Quickbuild.getServerService().hasPermission(userName, password, build.getConfiguration().getId(), ConfigurationPermission.ACCESS_ARTIFACTS.name())) {
                    File file = new File(build.getPublishDir(), filePath);
                    ServletUtils.serve(file, this.getServletContext().getMimeType(file.getName()), response);
                } else {
                    SecurityHelper.respondWithAccessDenied(response);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packageAgent(String fileName) {
        String agentDir = StringUtils.substringBefore((String)fileName, (String)".");
        File tempFile = new File(Bootstrap.getTempDir(), "packageagent_" + UUID.randomUUID().toString());
        File tempDir = FileUtils.createTempDir("packageagent");
        try {
            Tar.TarFileSet fileset;
            File packageDir = new File(tempDir, agentDir);
            FileUtils.copyFiles(Bootstrap.getBinDir(), "**/*wrapper*", new File(packageDir, "bin"));
            FileUtils.copyFile(new File(Bootstrap.getAssetDir(), "release"), new File(packageDir, "asset/release"));
            File bootstrapDir = new File(Bootstrap.installDir, "plugins/com.pmease.quickbuild.bootstrap");
            for (File file : bootstrapDir.listFiles()) {
                if (file.getName().contains("doc")) continue;
                File newFile = new File(packageDir, "plugins/com.pmease.quickbuild.bootstrap/" + file.getName());
                if (file.isFile()) {
                    FileUtils.copyFile(file, newFile);
                    continue;
                }
                FileUtils.copyDir(file, newFile);
            }
            FileUtils.copyFile(new File(Bootstrap.installDir, "conf/log4j.properties"), new File(packageDir, "conf/log4j.properties"));
            FileUtils.createFile(new File(packageDir, "conf/attributes.properties"));
            Properties agentConfig = new Properties();
            agentConfig.setProperty("serverUrl", Quickbuild.getInstance().getUrl());
            if (agentDir.equals("buildagent")) {
                agentConfig.setProperty("port", "8811");
                agentConfig.setProperty("token", UUID.randomUUID().toString());
            } else {
                agentConfig.setProperty("port", "8821");
            }
            FileUtils.saveProps(new File(packageDir, "conf/node.properties"), agentConfig, Bootstrap.getNodeComment());
            FileUtils.copyFile(new File(Bootstrap.installDir, "agent/" + agentDir + "/wrapper.conf"), new File(packageDir, "conf/wrapper.conf"));
            FileUtils.copyFile(new File(Bootstrap.getConfigDir(), "wrapper-license.conf"), new File(packageDir, "conf/wrapper-license.conf"));
            FileUtils.createDir(new File(packageDir, "logs"));
            FileUtils.createFile(new File(packageDir, "logs/console.log"));
            Project antProject = MiscUtils.createAntProject();
            FileUtils.copyFiles(new File(Bootstrap.installDir, "agent"), "*.bat", new File(packageDir, "bin"));
            FileUtils.copyFiles(new File(Bootstrap.installDir, "agent"), "*.sh", new File(packageDir, "bin"));
            FileUtils.copyFiles(new File(Bootstrap.installDir, "agent/" + agentDir), "*.bat", new File(packageDir, "bin"));
            FileUtils.copyFiles(new File(Bootstrap.installDir, "agent/" + agentDir), "*.sh", new File(packageDir, "bin"));
            if (fileName.endsWith("zip")) {
                FileUtils.copyFile(new File(Bootstrap.getAssetDir(), "batch-download.zip"), tempFile);
                Zip zip = new Zip();
                zip.setProject(antProject);
                zip.setDestFile(tempFile);
                zip.setCompress(true);
                fileset = new ZipFileSet();
                fileset.setProject(antProject);
                fileset.setDir(tempDir);
                fileset.setIncludes("**");
                fileset.setExcludes(agentDir + "/bin/*.sh, " + agentDir + "/bin/wrapper-*");
                zip.addZipfileset((ZipFileSet)fileset);
                fileset = new ZipFileSet();
                fileset.setProject(antProject);
                fileset.setDir(tempDir);
                fileset.setIncludes(agentDir + "/bin/*.sh, " + agentDir + "/bin/wrapper-*");
                fileset.setFileMode("755");
                zip.addZipfileset((ZipFileSet)fileset);
                zip.execute();
            } else {
                Tar tar = new Tar();
                tar.setProject(antProject);
                tar.setDestFile(tempFile);
                tar.setCompression((Tar.TarCompressionMethod)EnumeratedAttribute.getInstance(Tar.TarCompressionMethod.class, (String)"gzip"));
                fileset = new Tar.TarFileSet();
                fileset.setProject(antProject);
                fileset.setDir(tempDir);
                fileset.setIncludes("**");
                fileset.setExcludes(agentDir + "/bin/*.sh, " + agentDir + "/bin/wrapper-*");
                tar.add((ResourceCollection)fileset);
                fileset = new Tar.TarFileSet();
                fileset.setProject(antProject);
                fileset.setDir(tempDir);
                fileset.setIncludes(agentDir + "/bin/*.sh, " + agentDir + "/bin/wrapper-*");
                fileset.setFileMode("755");
                tar.add((ResourceCollection)fileset);
                tar.execute();
            }
            byte[] byArray = FileUtils.readFileAsBytes(tempFile);
            return byArray;
        }
        finally {
            try {
                FileUtils.deleteDir(tempDir);
            }
            finally {
                if (tempFile.exists()) {
                    FileUtils.deleteFile(tempFile);
                }
            }
        }
    }
}

