/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.AccessLogger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/batch_download";
    public static final String BUILD_ID_PARAM = "build_id";
    public static final String SRC_PATH_PARAM = "src_path";
    public static final String FILE_PATTERNS_PARAM = "file_patterns";
    private static final Logger logger = LoggerFactory.getLogger(BatchDownloadServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (Bootstrap.isServer()) {
            long time = System.currentTimeMillis();
            try {
                Build build;
                Context.setUser(SecurityHelper.authenticate(request, response));
                AccessLogger.log(request, Context.getUser());
                String buildIdOrName = request.getParameter(BUILD_ID_PARAM);
                if (buildIdOrName.indexOf(".") == -1) {
                    build = (Build)BuildManager.instance.load(Long.valueOf(buildIdOrName));
                } else {
                    build = BuildManager.instance.get(buildIdOrName);
                    if (build == null) {
                        throw new QuickbuildException("Can not find build named '" + buildIdOrName + "'.");
                    }
                }
                ArtifactStorage artifactStorage = build.getConfiguration().findArtifactStorage();
                if (!(artifactStorage instanceof ServerArtifactStorage)) {
                    String srcPath = request.getParameter(SRC_PATH_PARAM);
                    if (srcPath == null) {
                        throw new QuickbuildException("The param 'src_path' should be specified.");
                    }
                    if (srcPath.contains("..")) {
                        throw new QuickbuildException("Invalid source path specified.");
                    }
                    String filePatterns = request.getParameter(FILE_PATTERNS_PARAM);
                    if (filePatterns == null) {
                        filePatterns = "";
                    }
                    if (filePatterns.contains("..")) {
                        throw new QuickbuildException("Invalid file patterns specified.");
                    }
                    try {
                        response.sendRedirect(artifactStorage.getBatchSupport().getUrl(build, srcPath, filePatterns));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                String permission = ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name();
                boolean hasPermission = Bootstrap.isServer() ? SecurityHelper.hasPermission(build.getConfiguration(), permission) : SecurityHelper.hasPermission(Context.getUser(), build.getConfiguration(), permission);
                if (!hasPermission) {
                    SecurityHelper.respondWithAccessDenied(response);
                }
                this.process(request, response, build);
            }
            finally {
                Context.setUser(null);
                MetricsManager.instance.downloadRequestProcessed(System.currentTimeMillis() - time);
            }
        } else {
            Build build;
            String buildIdOrName = request.getParameter(BUILD_ID_PARAM);
            if (buildIdOrName.indexOf(".") == -1) {
                build = (Build)BuildManager.instance.load(Long.valueOf(buildIdOrName));
            } else {
                build = BuildManager.instance.get(buildIdOrName);
                if (build == null) {
                    throw new QuickbuildException("Can not find build named '" + buildIdOrName + "'.");
                }
            }
            String permission = ConfigurationPermission.BATCH_DOWNLOAD_ARTIFACTS.name();
            String accessToken = request.getParameter("token");
            if (accessToken != null && request.getHeader("Authorization") == null) {
                Pair<User, Date> userAndDate = SecurityHelper.parseAccessToken(accessToken);
                if (userAndDate.getSecond().before(new Date())) {
                    logger.warn("Access token is no longer valid, sending re-authentication request...");
                    SecurityHelper.respondWithAccessDenied(response);
                } else {
                    Long userId = userAndDate.getFirst().getId();
                    if (!Quickbuild.getServerService().hasPermission(userId, build.getConfiguration().getId(), permission)) {
                        SecurityHelper.respondWithAccessDenied(response);
                    } else {
                        this.process(request, response, build);
                    }
                }
            } else {
                String userName = null;
                String password = null;
                String authorizationHeader = request.getHeader("Authorization");
                if (authorizationHeader != null) {
                    String token = StringUtils.substringAfter((String)authorizationHeader, (String)" ");
                    token = new String(Base64.decodeBase64((byte[])token.getBytes()));
                    userName = StringUtils.substringBefore((String)token, (String)":");
                    password = StringUtils.substringAfter((String)token, (String)":");
                }
                if (!Quickbuild.getServerService().hasPermission(userName, password, build.getConfiguration().getId(), permission)) {
                    SecurityHelper.respondWithAccessDenied(response);
                } else {
                    this.process(request, response, build);
                }
            }
        }
    }

    private void process(HttpServletRequest request, HttpServletResponse response, Build build) {
        String srcPath = request.getParameter(SRC_PATH_PARAM);
        if (srcPath == null) {
            throw new QuickbuildException("The param 'src_path' should be specified.");
        }
        if (srcPath.contains("..")) {
            throw new QuickbuildException("Invalid source path specified.");
        }
        String filePatterns = request.getParameter(FILE_PATTERNS_PARAM);
        if (filePatterns == null) {
            filePatterns = "";
        }
        if (filePatterns.contains("..")) {
            throw new QuickbuildException("Invalid file patterns specified.");
        }
        try {
            String encodedFileName;
            File dir = new File(build.getPublishDir(), srcPath);
            response.setContentType("application/zip");
            try {
                encodedFileName = URLEncoder.encode(dir.getName() + ".zip", "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException(e1);
            }
            response.setHeader("Content-Disposition", "inline;filename*=UTF-8''" + encodedFileName);
            FileUtils.zip(dir, filePatterns, false, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

