/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.ResourceUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class AssetServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Map<String, Long> lastModifiedCache = new ConcurrentHashMap<String, Long>();

    protected long getLastModified(HttpServletRequest request) {
        this.validate(request);
        String uri = request.getRequestURI();
        Long lastModified = this.lastModifiedCache.get(uri);
        if (lastModified == null) {
            lastModified = ResourceUtils.getLastModified(uri);
            this.lastModifiedCache.put(uri, lastModified);
        }
        return lastModified;
    }

    private void validate(HttpServletRequest request) {
        if (request.getRequestURI().contains("..")) {
            throw new QuickbuildException("Invalid request asset: " + request.getRequestURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.validate(request);
        String requestPath = request.getRequestURI();
        InputStream is = null;
        try {
            int bytesRead;
            is = ResourceUtils.isExternalAsset(requestPath) ? new FileInputStream(ResourceUtils.getExternalAsset(requestPath)) : ResourceUtils.getAssetStream(requestPath);
            String contentType = this.getServletContext().getMimeType(requestPath);
            if (StringUtils.isBlank((String)contentType)) {
                response.setContentType("application/octet-stream");
            } else {
                response.setContentType(contentType);
            }
            response.setContentLength((int)ResourceUtils.getAssetLength(requestPath));
            response.setHeader("cache-control", "max-age=31536000");
            byte[] data = new byte[4096];
            ServletOutputStream os = response.getOutputStream();
            while ((bytesRead = is.read(data)) != -1) {
                os.write(data, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
    }
}

