/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.ResourceUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class AssetPack
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String name;
    private String[] assets;
    private byte[] content;
    private Date lastModified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetPack(String name, String[] assets) {
        this.name = name;
        this.assets = assets;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzipos = new GZIPOutputStream(baos);
            for (String asset : assets) {
                InputStream is = null;
                try {
                    int bytesRead;
                    is = ResourceUtils.getAssetStream(asset);
                    byte[] data = new byte[8192];
                    while ((bytesRead = is.read(data)) != -1) {
                        gzipos.write(data, 0, bytesRead);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            gzipos.finish();
            this.content = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.lastModified = new Date();
    }

    private String getMimeType() {
        if (this.name.endsWith(".css")) {
            return "text/css";
        }
        if (this.name.endsWith(".js")) {
            return "text/javascript";
        }
        throw new QuickbuildException("Asset pack type unknown: " + this.name);
    }

    public void renderHead(IHeaderResponse response) {
        String mimeType = this.getMimeType();
        if (Application.get().usesDevelopmentConfig()) {
            for (String asset : this.assets) {
                if (mimeType.equals("text/css")) {
                    response.renderCSSReference(asset + "?v=" + ResourceUtils.getLastModified(asset));
                    continue;
                }
                response.renderJavaScriptReference(asset + "?v=" + ResourceUtils.getLastModified(asset));
            }
        } else if (mimeType.endsWith("text/css")) {
            response.renderCSSReference(this.getUrl());
        } else {
            response.renderJavaScriptReference(this.getUrl());
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        return this.lastModified.getTime();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(this.getMimeType());
        response.setHeader("Content-Encoding", "gzip");
        response.setHeader("cache-control", "max-age=315360000");
        response.setContentLength(this.content.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(this.content);
    }

    public void registerHandler(ServletContextHandler context) {
        context.addServlet(new ServletHolder((Servlet)this), this.name);
    }

    private String getUrl() {
        return this.name + "?v=" + this.lastModified.getTime();
    }
}

