/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.web;

import com.pmease.quickbuild.model.User;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogger {
    private static final Logger logger = LoggerFactory.getLogger(AccessLogger.class);

    public static void log(HttpServletRequest request, User user) {
        if (logger.isTraceEnabled()) {
            String url = request.getRequestURL().toString();
            if (StringUtils.isNotBlank((String)request.getQueryString())) {
                url = url + "?" + request.getQueryString();
            }
            if (user != null) {
                logger.trace("User '" + user.getDisplayName() + "' is requesting '" + url + "'...");
            } else {
                logger.trace("Anonymous user is requesting '" + url + "'...");
            }
        }
    }
}

