/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.AccessListener;
import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.joda.time.format.DateTimeFormat;

@ScriptApi(value="Represents a variable defined in configuration. If this object is concatenated directly with other strings, the <em>toString()</em> method will be called implicitly. For example the string <em>hello ${vars.get(\"varName\").getValue()}</em> has the same effect as <em>hello ${vars.get(\"varName\")}</em>.")
public class VariableWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uuid = UUID.randomUUID().toString();
    private static ThreadLocal<Stack<String>> accessStack = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    private static List<AccessListener<VariableWrapper>> accessListeners = new ArrayList<AccessListener<VariableWrapper>>();
    private String name;
    private String value;
    private boolean secret;
    private boolean dirty;
    private String snapshot;
    private boolean interpolate;

    public VariableWrapper(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @ScriptApi(value="Get name of the variable.")
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get value of the variable. Null will be returned if the variable value is left empty.")
    public String getValue() {
        for (String each : accessStack.get()) {
            if (!each.equals(this.uuid)) continue;
            throw new QuickbuildException("Found circular reference of variable: " + this.name);
        }
        accessStack.get().push(this.uuid);
        try {
            this.snapshot = this.interpolate ? Quickbuild.getInstance(ScriptEngine.class).interpolate(this.value, Context.buildEvalContext(null, null)) : this.value;
            Object object = accessListeners;
            synchronized (object) {
                for (AccessListener<VariableWrapper> each : accessListeners) {
                    each.onAccess(this);
                }
            }
            object = this.snapshot;
            return object;
        }
        finally {
            accessStack.get().pop();
        }
    }

    @ScriptApi(value="Set variable value as specified string and persist the value into database.")
    public void setValue(String value) {
        this.setValue(value, true);
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(String snapshot) {
        this.snapshot = snapshot;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(boolean secret) {
        this.secret = secret;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setValue(String value, boolean persist) {
        Configuration declarer;
        this.value = value;
        this.dirty = true;
        this.snapshot = value;
        if (persist && !Context.getConfiguration().isDryRun() && (declarer = Context.getConfiguration().findVarDeclarer(this.getName())) != null) {
            ConfigurationManager.instance.saveVariable(declarer, this.getName(), this.snapshot);
        }
    }

    @ScriptApi(value="Whether or not value of the variable is empty.")
    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.getValue());
    }

    @ScriptApi(value="Increase value of the variable as integer by one, and return the original value. If the passed param is true, the increased variable value will be persisted into database.")
    public int increase(boolean persist) {
        int intValue = this.getIntValue();
        this.setValue(intValue + 1, persist);
        return intValue;
    }

    @ScriptApi(value="Increase value of the variable as integer by one, and return the original value. The increased variable will be saved into configuration.")
    public int increase() {
        return this.increase(true);
    }

    @ScriptApi(value="Decrease value of the variable as integer by one, and return the original value. If the passed param is true, the decreased variable will be persisted into database.")
    public int decrease(boolean persist) {
        int intValue = this.getIntValue();
        this.setValue(intValue - 1, persist);
        return intValue;
    }

    @ScriptApi(value="Decrease value of the variable as integer by one, and return the original value. The decreased variable will be saved into configuration.")
    public int decrease() {
        return this.decrease(true);
    }

    @ScriptApi(value="Get variable value as integer.")
    public int getIntValue() {
        if (StringUtils.isBlank((String)this.getValue())) {
            return 0;
        }
        return Integer.parseInt(this.getValue());
    }

    @ScriptApi(value="This method is alias of getIntValue()")
    public int asInt() {
        return this.getIntValue();
    }

    @ScriptApi(value="Get variable value as integer. An empty list will be returned if the variable value is null or is an empty string.")
    public List<String> getListValue() {
        if (this.getValue() != null) {
            return StringUtils.splitAndTrim(this.getValue());
        }
        return new ArrayList<String>();
    }

    @ScriptApi(value="This method is alias of getListValue()")
    public List<String> asList() {
        return this.getListValue();
    }

    @ScriptApi(value="Get variable value as bean. Null will be returned if the variable value is not set.")
    public Object getBeanValue() {
        if (this.getValue() != null) {
            return StringUtils.string2obj(this.getValue());
        }
        return null;
    }

    @ScriptApi(value="This method is alias of getBeanValue()")
    public Object asBean() {
        return this.getBeanValue();
    }

    @ScriptApi(value="Set variable value as specified integer. The second param determines whether or not to persist the value into database.")
    public void setValue(int value, boolean persist) {
        this.setValue(String.valueOf(value), persist);
    }

    @ScriptApi(value="Set variable value as specified integer and persist the value into database.")
    public void setValue(int value) {
        this.setValue(value, true);
    }

    @ScriptApi(value="Get value of the variable as boolean. True will be returned if lowercase of the value equals to <b>\"true\"</b>, <b>\"yes\"</b>, or <b>\"y\"</b>; otherwise, false will be returned.")
    public boolean getBooleanValue() {
        String value = this.getValue();
        return value.equalsIgnoreCase("y") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true");
    }

    @ScriptApi(value="This method is alias of getBooleanValue().")
    public boolean asBoolean() {
        return this.getBooleanValue();
    }

    @ScriptApi(value="Get value of the variable as date. Null will be returned if the value is not set.")
    public Date getDateValue() {
        if (this.getValue() == null) {
            return null;
        }
        try {
            String value = this.getValue().trim();
            if (value.contains(" +") || value.contains(" -")) {
                if (StringUtils.substringBeforeLast((String)value, (String)" ").contains("-")) {
                    if (value.contains(":")) {
                        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm Z").parseDateTime(value).toDate();
                    }
                    return DateTimeFormat.forPattern((String)"yyyy-MM-dd Z").parseDateTime(value).toDate();
                }
                if (value.contains(":")) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT" + StringUtils.substringAfterLast((String)value, (String)" ")));
                    String dateStr = sdf.format(new Date());
                    return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm Z").parseDateTime(dateStr + " " + value).toDate();
                }
                throw new QuickbuildException("Invalid date time format: " + value);
            }
            if (value.contains("-")) {
                if (value.contains(":")) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    sdf.setTimeZone(Context.getTimeZone());
                    return sdf.parse(value);
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.setTimeZone(Context.getTimeZone());
                return sdf.parse(value);
            }
            if (value.contains(":")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.setTimeZone(Context.getTimeZone());
                String dateStr = sdf.format(new Date());
                sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                sdf.setTimeZone(Context.getTimeZone());
                return sdf.parse(dateStr + " " + value);
            }
            throw new QuickbuildException("Invalid date time format: " + value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @ScriptApi(value="This method is alias of getDateValue().")
    public Date asDate() {
        return this.getDateValue();
    }

    @ScriptApi(value="Set value of the variable as specified boolean and persist it into database.")
    public void setValue(boolean value) {
        this.setValue(value, true);
    }

    @ScriptApi(value="Set variable value as specified boolean. The second param determines whether or not to persist the value into database.")
    public void setValue(boolean value, boolean persist) {
        this.setValue(String.valueOf(value), persist);
    }

    @ScriptApi(value="Get string representation of the variable value. This returns the same as method <em>getValue()</em>.")
    public String toString() {
        return this.getValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VariableWrapper)) {
            return false;
        }
        VariableWrapper otherVar = (VariableWrapper)other;
        return new EqualsBuilder().append((Object)this.name, (Object)otherVar.name).append((Object)this.value, (Object)otherVar.value).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.value).toHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAccessListener(AccessListener<VariableWrapper> listener) {
        List<AccessListener<VariableWrapper>> list = accessListeners;
        synchronized (list) {
            accessListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAccessListener(AccessListener<VariableWrapper> listener) {
        List<AccessListener<VariableWrapper>> list = accessListeners;
        synchronized (list) {
            accessListeners.remove(listener);
        }
    }
}

