/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.variable.VariableWrapper;
import com.pmease.quickbuild.web.component.editor.BeanEditor;
import com.pmease.quickbuild.web.component.editor.EditContext;
import com.pmease.quickbuild.web.component.editor.TypeEditor;
import java.util.Collection;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.hibernate.util.SerializationHelper;

@ScriptApi
public class VariableAccessor {
    @ScriptApi(value="Get variable object of specified name in current build. Null will be returned if variable is not found.")
    public VariableWrapper get(String varName) {
        Map<String, VariableWrapper> vars;
        EditContext.EditableProperty property;
        BeanEditor beanEditor;
        if (Context.getComponent() instanceof TypeEditor && (beanEditor = Context.getComponent().visitParents(BeanEditor.class, new IVisitor<Component, BeanEditor>(){

            public void component(Component component, IVisit<BeanEditor> visit) {
                BeanEditor beanEditor = (BeanEditor)((Object)component);
                String beanClassName = beanEditor.getEditContext().getBeanClass().getName();
                if (beanClassName.startsWith("BuildVariablePromptBean") || beanClassName.startsWith("PromoteVariablePromptBean")) {
                    visit.stop((Object)beanEditor);
                }
            }
        })) != null && (property = EditContext.EditableProperty.get("/" + varName)) != null) {
            VariableWrapper wrapper = new VariableWrapper(property.getName(), (String)property.getValue());
            wrapper.setInterpolate(false);
            return wrapper;
        }
        Step step = Context.getStep();
        if (step != null && (vars = step.getVariableWrappers()) != null) {
            VariableWrapper var = vars.get(varName);
            if (var != null) {
                return var;
            }
            var = Context.get().getVar(varName);
            if (var != null) {
                vars.put(varName, (VariableWrapper)SerializationHelper.clone(var));
            }
            return var;
        }
        return Context.get().getVar(varName);
    }

    @ScriptApi(value="Get value of the variable of specified name in current build. Null will be returned if variable is not found or if the value is empty.")
    public String getValue(String varName) {
        VariableWrapper var = this.get(varName);
        if (var != null) {
            return var.getValue();
        }
        return null;
    }

    @ScriptApi(value="Get all accessed variables")
    public Collection<VariableWrapper> getAll() {
        return Context.get().getVariables().values();
    }
}

