/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.pmease.quickbuild.variable.CleartextValueProvider;
import com.pmease.quickbuild.variable.DoNotPrompt;
import com.pmease.quickbuild.variable.PromptSetting;
import com.pmease.quickbuild.variable.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi(value="This class represents a defined variable in configuration setting or promotion setting.")
public class Variable
implements Serializable,
Validatable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private ValueProvider valueProvider = new CleartextValueProvider();
    private PromptSetting promptSetting = new DoNotPrompt();
    private transient Long configurationId;

    @Editable(order=100)
    @NotEmpty
    @ScriptApi(value="Get name of the variable.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=150)
    @ScriptApi(value="Get description of the variable.")
    @Multiline
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(name="Value", order=200, description="Specify variable value here.")
    @ScriptApi(value="Get value of the variable.")
    @NotNull
    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public void setValueProvider(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    @ScriptApi(value="Get value of the variable.")
    public String getValue() {
        return this.getValueProvider().getValue(this);
    }

    @ScriptApi(value="Set value of the variable.")
    public void setValue(String value) {
        this.getValueProvider().setValue(this, value);
    }

    @Editable(order=300, description="Specify how this variable will be prompted when configuration is manually triggered or if build is promoted. If a variable is set to prompt, the prompted value specified by the user will be used for the variable at build or promotion time. For scheduled build, the variable will not be prompted and the default value specified will be used instead.")
    @NotNull
    public PromptSetting getPromptSetting() {
        return this.promptSetting;
    }

    public void setPromptSetting(PromptSetting promptSetting) {
        this.promptSetting = promptSetting;
    }

    public static Map<String, String> list2map(List<Variable> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Variable element : list) {
            map.put(element.getName(), element.getValue());
        }
        return map;
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (properties.contains("name")) {
            char c = this.getName().charAt(0);
            if (!Character.isLetter(c) && c != '_') {
                errorContext.setError("name", "Variable name should starts with letter or the underscore character.");
            } else {
                for (int i = 0; i < this.getName().length(); ++i) {
                    c = this.getName().charAt(i);
                    if (c == '_' || Character.isLetter(c) || Character.isDigit(c)) continue;
                    errorContext.setError("name", "Variable name can only consist of letters, digits and the underscore character.");
                    break;
                }
            }
        }
    }

    public static boolean contains(Collection<Variable> variables, Variable var) {
        for (Variable each : variables) {
            if (!each.getName().equals(var.getName())) continue;
            return true;
        }
        return false;
    }

    @ScriptApi(value="Get string representation of the variable value. This returns the same as method <em>getValue()</em>.")
    public String toString() {
        return this.getValue();
    }

    public Long getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(Long configurationId) {
        this.configurationId = configurationId;
    }
}

