/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class PromptSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String displayName;
    private String description;
    private boolean remember = true;
    private boolean allowEmpty;
    private int order = 100;
    private String condition;
    private boolean readOnly;

    @Editable(order=100, description="Optionally specify display name of the variable when promoted. If not specified, the variable name will be displayed.")
    @Scriptable
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Editable(order=150, description="Optionally specify description of the variable when prompted.")
    @Multiline(value=2)
    @Scriptable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=150, description="This affects the initial value when the variable is prompted. If checked, the value specified last time by the same user will be remembered and used as the initial value. Otherwise, the default value will always be used as initial value.")
    public boolean isRemember() {
        return this.remember;
    }

    public void setRemember(boolean remember) {
        this.remember = remember;
    }

    @Editable(order=200, description="Whether or not this variable is allowed to be empty.")
    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    @Editable(order=250, description="Specify prompt order of the variable. Variables with same order value will be prompted in the definition order.")
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Editable(order=275, description="If specified, this variable will be prompted only when the script is evaluated to true.")
    @Script
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Editable(order=300, description="Whether or not this variable is read only. If set to read only, the variable will not be able to be modified at prompt time.")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public abstract String getPropertyDef(String var1, int var2);

    protected String escape(String str) {
        String escaped = StringEscapeUtils.escapeJava((String)str);
        escaped = escaped.replace("\\/", "/");
        escaped = escaped.replace("$", "\\$");
        return escaped;
    }
}

