/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.variable.PromptSetting;
import javax.validation.constraints.Min;

@Editable(order=200, name="prompt as text input")
public class PromptAsTextInput
extends PromptSetting {
    private static final long serialVersionUID = 1L;
    private int lines = 1;
    private String pattern;

    @Editable(order=1000, description="Specify number of lines for the this text input")
    @Min(value=1L)
    public int getLines() {
        return this.lines;
    }

    public void setLines(int lines) {
        this.lines = lines;
    }

    @Editable(order=1100, description="Optionally specify a <a href='http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html'>regular expression pattern</a> for valid values of this variable.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getPropertyDef(String name, int index) {
        String methodSuffix = BeanUtils.getMethodSuffix(name);
        StringBuffer buffer = new StringBuffer("public String " + name + ";\n");
        if (this.getDisplayName() != null) {
            if (this.getDescription() != null) {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
            } else {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", order=" + index + ")\n");
            }
        } else if (this.getDescription() != null) {
            buffer.append("@Editable(name=\"" + name + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
        } else {
            buffer.append("@Editable(name=\"" + name + "\", order=" + index + ")\n");
        }
        if (!this.isAllowEmpty()) {
            buffer.append("@NotEmpty\n");
        }
        if (this.isReadOnly()) {
            buffer.append("@ReadOnly\n");
        }
        if (this.getLines() != 1) {
            buffer.append("@Multiline(" + this.getLines() + ")\n");
        }
        if (this.getPattern() != null) {
            buffer.append("@Pattern(regexp=\"" + this.getPattern() + "\", message=\"Should match regular expression: " + this.getPattern() + "\")\n");
        }
        buffer.append("@Property(\"" + name + "\")\n");
        buffer.append("public String get" + methodSuffix + "() {\n");
        buffer.append("return " + name + ";\n}\n");
        buffer.append("public void set" + methodSuffix + "(String value){\n");
        buffer.append("this." + name + "=value;\n}\n");
        return buffer.toString();
    }
}

