/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.PromptSetting;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=150, name="prompt as selection box")
public class PromptAsSelectionBox
extends PromptSetting {
    private static final long serialVersionUID = 1L;
    private String choices;

    @Editable(order=1000, description="Specify choice values of the selection box separated by comma or newline. For example: <b>1.0, 2.0, 3.0</b>")
    @NotEmpty
    @Multiline
    @Scriptable
    public String getChoices() {
        return this.choices;
    }

    public void setChoices(String choices) {
        this.choices = choices;
    }

    @Override
    public String getPropertyDef(String name, int index) {
        String methodSuffix = BeanUtils.getMethodSuffix(name);
        StringBuffer buffer = new StringBuffer("public String " + name + ";\n");
        if (this.getDisplayName() != null) {
            if (this.getDescription() != null) {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
            } else {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", order=" + index + ")\n");
            }
        } else if (this.getDescription() != null) {
            buffer.append("@Editable(name=\"" + this.escape(name) + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
        } else {
            buffer.append("@Editable(name=\"" + this.escape(name) + "\", order=" + index + ")\n");
        }
        buffer.append("@ChoiceProvider(\"get" + methodSuffix + "Choices\")\n");
        if (!this.isAllowEmpty()) {
            buffer.append("@NotNull\n");
        }
        if (this.isReadOnly()) {
            buffer.append("@ReadOnly\n");
        }
        buffer.append("@Property(\"" + name + "\")\n");
        buffer.append("public String get" + methodSuffix + "() {\n");
        buffer.append("  return " + name + ";\n}\n");
        buffer.append("public void set" + methodSuffix + "(String value){\n");
        buffer.append("  this." + name + "=value;\n}\n");
        buffer.append("private static java.util.List get" + methodSuffix + "Choices() {\n");
        Long configurationId = Context.getConfiguration().getId();
        Long buildId = Context.getBuild() != null ? Context.getBuild().getId() : null;
        buffer.append("  return com.pmease.quickbuild.variable.PromptAsSelectionBox.toList(\"" + this.escape(this.choices) + "\", " + configurationId + ", " + buildId + ");\n}\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> toList(String choices, Long configurationId, Long buildId) {
        if (buildId != null) {
            Context.push((Build)BuildManager.instance.load(buildId));
        } else {
            Context.push((Configuration)ConfigurationManager.instance.load(configurationId));
        }
        try {
            choices = ScriptEngine.instance.interpolate(choices, Context.buildEvalContext(null, null));
        }
        finally {
            Context.pop();
        }
        ArrayList<String> choiceList = new ArrayList<String>();
        if (choices != null) {
            for (String choice : StringUtils.splitAndTrim(choices)) {
                choiceList.add(choice);
            }
        }
        return choiceList;
    }
}

