/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.variable.PromptSetting;

@Editable(order=400, name="prompt as numeric input")
public class PromptAsNumericInput
extends PromptSetting {
    private static final long serialVersionUID = 1L;
    private Integer minValue;
    private Integer maxValue;

    @Editable(order=1000, description="Optionally specify the minimum value allowed.")
    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    @Editable(order=1100, description="Optionally specify the maximum value allowed.")
    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public String getPropertyDef(String name, int index) {
        String methodSuffix = BeanUtils.getMethodSuffix(name);
        StringBuffer buffer = new StringBuffer("public Integer " + name + ";\n");
        if (this.getDisplayName() != null) {
            if (this.getDescription() != null) {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
            } else {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", order=" + index + ")\n");
            }
        } else if (this.getDescription() != null) {
            buffer.append("@Editable(name=\"" + name + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
        } else {
            buffer.append("@Editable(name=\"" + name + "\", order=" + index + ")\n");
        }
        if (this.minValue != null) {
            if (this.maxValue != null) {
                buffer.append("@Range(min=" + this.minValue.toString() + "L,max=" + this.maxValue.toString() + "L)\n");
            } else {
                buffer.append("@Range(min=" + this.minValue.toString() + "L)\n");
            }
        } else if (this.maxValue != null) {
            buffer.append("@Range(max=" + this.maxValue.toString() + "L)\n");
        }
        if (!this.isAllowEmpty()) {
            buffer.append("@NotNull\n");
        }
        if (this.isReadOnly()) {
            buffer.append("@ReadOnly\n");
        }
        buffer.append("@Property(\"" + name + "\")\n");
        buffer.append("public Integer get" + methodSuffix + "() {\n");
        buffer.append("return " + name + ";\n}\n");
        buffer.append("public void set" + methodSuffix + "(Integer value){\n");
        buffer.append("this." + name + "=value;\n}\n");
        return buffer.toString();
    }
}

