/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.variable.PromptSetting;

@Editable(order=300, name="prompt as check box")
public class PromptAsCheckbox
extends PromptSetting {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isAllowEmpty() {
        return false;
    }

    @Override
    public String getPropertyDef(String name, int index) {
        String methodSuffix = BeanUtils.getMethodSuffix(name);
        StringBuffer buffer = new StringBuffer("public boolean " + name + ";\n");
        if (this.getDisplayName() != null) {
            if (this.getDescription() != null) {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
            } else {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", order=" + index + ")\n");
            }
        } else if (this.getDescription() != null) {
            buffer.append("@Editable(name=\"" + name + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
        } else {
            buffer.append("@Editable(name=\"" + name + "\", order=" + index + ")\n");
        }
        if (this.isReadOnly()) {
            buffer.append("@ReadOnly\n");
        }
        buffer.append("@Property(\"" + name + "\")\n");
        buffer.append("public boolean get" + methodSuffix + "() {\n");
        buffer.append("return " + name + ";\n}\n");
        buffer.append("public void set" + methodSuffix + "(boolean value){\n");
        buffer.append("this." + name + "=value;\n}\n");
        return buffer.toString();
    }
}

