/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.variable;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.PromptBeanProvider;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.variable.PromptSetting;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(order=1000, name="prompt as bean input")
public class PromptAsBeanInput
extends PromptSetting {
    private static final long serialVersionUID = 1L;
    private String beanName;

    @Editable(name="Bean", description="Select the bean to collect user input for this variable. After collecting user input, the variable can be accessed as selected bean via scripting API <b>vars.get(&quot;&lt;var name&gt;&quot;).asBean()</b>, and then you can traverse the object graph to use various bean fields as necessary.")
    @NotEmpty
    @ChoiceProvider(value="getBeanNames")
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public String getPropertyDef(String name, int index) {
        Class<? extends Serializable> beanClass = null;
        for (PromptBeanProvider each : PluginManager.instance.getExtensions(PromptBeanProvider.class)) {
            if (!EditorHelper.getName(each.getPromptBeanClass()).equals(this.getBeanName())) continue;
            beanClass = each.getPromptBeanClass();
        }
        if (beanClass == null) {
            throw new QuickbuildException(ExceptionUtils.buildMessage("Prompt bean not found", "variable", name, "bean", this.getBeanName()));
        }
        String methodSuffix = BeanUtils.getMethodSuffix(name);
        StringBuffer buffer = new StringBuffer("public " + beanClass.getName() + " " + name);
        if (!this.isAllowEmpty()) {
            buffer.append("=new " + beanClass.getName() + "();\n");
        } else {
            buffer.append(";\n");
        }
        if (this.getDisplayName() != null) {
            if (this.getDescription() != null) {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
            } else {
                buffer.append("@Editable(name=\"" + this.escape(this.getDisplayName()) + "\", order=" + index + ")\n");
            }
        } else if (this.getDescription() != null) {
            buffer.append("@Editable(name=\"" + name + "\", description=\"" + this.escape(this.getDescription()) + "\", order=" + index + ")\n");
        } else {
            buffer.append("@Editable(name=\"" + name + "\", order=" + index + ")\n");
        }
        if (!this.isAllowEmpty()) {
            buffer.append("@NotNull\n");
        }
        if (this.isReadOnly()) {
            buffer.append("@ReadOnly\n");
        }
        buffer.append("@Property(\"" + name + "\")\n");
        buffer.append("public " + beanClass.getName() + " get" + methodSuffix + "() {\n");
        buffer.append("return " + name + ";\n}\n");
        buffer.append("public void set" + methodSuffix + "(" + beanClass.getName() + " value){\n");
        buffer.append("this." + name + "=value;\n}\n");
        return buffer.toString();
    }

    private static List<String> getBeanNames() {
        ArrayList<String> available = new ArrayList<String>();
        for (PromptBeanProvider each : PluginManager.instance.getExtensions(PromptBeanProvider.class)) {
            available.add(EditorHelper.getName(each.getPromptBeanClass()));
        }
        return available;
    }
}

