/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.validation.validator;

import com.pmease.quickbuild.annotation.Name;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;

public class NameValidator
implements ConstraintValidator<Name, String> {
    public static final String invalidChars = ", / \\ : * ? \" < > | [ ]";

    public void initialize(Name constaintAnnotation) {
    }

    public static boolean isValid(String name) {
        return StringUtils.containsNone((String)name, (String)StringUtils.deleteWhitespace((String)invalidChars));
    }

    public static String correct(String name) {
        String trimedInvalidChars = StringUtils.deleteWhitespace((String)invalidChars);
        return StringUtils.replaceChars((String)name, (String)StringUtils.deleteWhitespace((String)invalidChars), (String)StringUtils.repeat((String)"_", (int)trimedInvalidChars.length()));
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintContext) {
        if (value == null) {
            return true;
        }
        return NameValidator.isValid(value);
    }
}

