/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.validation;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.util.ArrayList;
import java.util.List;

public class EditErrorContext
implements ErrorContext {
    private EditContext editContext;

    public EditErrorContext(EditContext editContext) {
        this.editContext = editContext;
    }

    @Override
    public String getError() {
        return this.editContext.getError();
    }

    @Override
    public void setError(String error) {
        this.editContext.setError(error);
    }

    @Override
    public String getError(String property) {
        return this.editContext.getProperty(property).getError();
    }

    @Override
    public void setError(String property, String error) {
        this.editContext.getProperty(property).setError(error);
    }

    @Override
    public List<ErrorContext> getErrorContexts(String propertyName) {
        EditContext.EditableProperty property = this.editContext.getProperty(propertyName);
        if (property.getValue() == null) {
            return null;
        }
        if (property.getValue() instanceof List) {
            List editContexts = (List)property.getValue();
            ArrayList<ErrorContext> errorContexts = new ArrayList<ErrorContext>();
            for (EditContext editContext : editContexts) {
                errorContexts.add(new EditErrorContext(editContext));
            }
            return errorContexts;
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage("Error contexts does not exist", "class", this.editContext.getBeanClass().getName(), "property", propertyName));
    }

    @Override
    public ErrorContext getErrorContext(String propertyName) {
        EditContext.EditableProperty property = this.editContext.getProperty(propertyName);
        if (property.getValue() == null) {
            return null;
        }
        if (property.getValue() instanceof EditContext) {
            return new EditErrorContext((EditContext)property.getValue());
        }
        throw new QuickbuildException(ExceptionUtils.buildMessage("Error context does not exist", "class", this.editContext.getBeanClass().getName(), "property", propertyName));
    }

    @Override
    public boolean hasError() {
        return this.editContext.hasError();
    }
}

