/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util.datastore;

import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.datastore.DataStore;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class FileDb {
    private DataStore<File> store;
    private Migrator migrator;

    public FileDb(File dbDir, Migrator migrator) {
        this.migrator = migrator;
        try {
            this.store = new DataStore<File>(dbDir.getCanonicalPath(), dbDir, migrator.getClass()){

                @Override
                public String readDataVersion(File dataSource) {
                    return FileDb.this.readDataVersion(dataSource);
                }

                @Override
                public void writeDataVersion(File dataSource, String dataVersion) {
                    FileDb.this.writeDataVersion(dataSource, dataVersion);
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object read(final Callback callback) {
        return this.store.read(new DataStore.Callback<File>(){

            @Override
            public Object execute(File dbDir) {
                return FileDb.execute(dbDir, callback, true);
            }
        });
    }

    public void write(final Callback callback) {
        this.store.write(new DataStore.Callback<File>(){

            @Override
            public Object execute(final File dbDir) {
                final boolean dbEmpty = !new File(dbDir, "filedb.h2.db").exists();
                return FileDb.execute(dbDir, new Callback(){

                    @Override
                    public Object execute(Connection conn) throws SQLException {
                        if (dbEmpty) {
                            FileUtils.createDir(dbDir);
                            FileDb.this.migrator.init(conn);
                        }
                        callback.execute(conn);
                        return null;
                    }
                }, false);
            }
        }, true);
    }

    public String readDataVersion(File dbDir) {
        File versionFile = new File(dbDir, "version");
        if (versionFile.exists()) {
            return FileUtils.readFileAsString(versionFile);
        }
        return null;
    }

    public void writeDataVersion(File dbDir, String dataVersion) {
        FileUtils.createDir(dbDir);
        FileUtils.writeFile(new File(dbDir, "version"), dataVersion);
    }

    public static Object execute(File dbDir, Callback callback, boolean readOnly) {
        Connection conn = null;
        try {
            conn = FileDb.getConnection(dbDir, readOnly);
            Object object = callback.execute(conn);
            return object;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public static Connection getConnection(File dbDir, boolean readOnly) {
        try {
            return DriverManager.getConnection("jdbc:h2:" + new File(dbDir, "filedb").getAbsolutePath() + (readOnly ? ";ACCESS_MODE_DATA=r" : ""), "sa", "");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Migrator {
        public void init(Connection var1) throws SQLException;
    }

    public static interface Callback {
        public Object execute(Connection var1) throws SQLException;
    }
}

