/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util.datastore;

import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.util.LockUtils;
import java.util.concurrent.locks.Lock;

public abstract class DataStore<T> {
    private String dataSourceId;
    private T dataSource;
    private Class<?> dataMigrator;

    public DataStore(String dataSourceId, T dataSource, Class<?> dataMigrator) {
        this.dataSourceId = dataSourceId;
        this.dataSource = dataSource;
        this.dataMigrator = dataMigrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object read(Callback<T> callback) {
        Lock readLock = LockUtils.lockForRead("datasource:" + this.dataSourceId);
        try {
            String dataVersion = this.readDataVersion(this.dataSource);
            if (dataVersion != null) {
                String appVersion = MigrationHelper.getVersion(this.dataMigrator.getClass());
                if (!dataVersion.equals(appVersion)) {
                    Lock writeLock = LockUtils.lockForWrite("datasource:" + this.dataSourceId);
                    try {
                        dataVersion = this.readDataVersion(this.dataSource);
                        if (!dataVersion.equals(appVersion)) {
                            MigrationHelper.migrate(dataVersion, this.dataMigrator.getClass(), this.dataSource);
                            this.writeDataVersion(this.dataSource, appVersion);
                        }
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
                Object object = callback.execute(this.dataSource);
                return object;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Callback<T> callback, boolean migrateExisting) {
        Lock writeLock = LockUtils.lockForWrite("datasource:" + this.dataSourceId);
        try {
            String dataVersion;
            String appVersion = MigrationHelper.getVersion(this.dataMigrator.getClass());
            if (migrateExisting && (dataVersion = this.readDataVersion(this.dataSource)) != null && !dataVersion.equals(appVersion)) {
                MigrationHelper.migrate(dataVersion, this.dataMigrator.getClass(), this.dataSource);
            }
            callback.execute(this.dataSource);
            this.writeDataVersion(this.dataSource, appVersion);
        }
        finally {
            writeLock.unlock();
        }
    }

    public abstract String readDataVersion(T var1);

    public abstract void writeDataVersion(T var1, String var2);

    public static interface Callback<T> {
        public Object execute(T var1);
    }
}

