/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WaitableHashMap<K, V>
implements Map<K, V> {
    private Map<K, V> delegate = new HashMap();

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public synchronized V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Either key or value argument can not be null.");
        }
        V previous = this.delegate.put(key, value);
        this.notifyAll();
        return previous;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        if (t.containsKey(null) || t.containsValue(null)) {
            throw new IllegalArgumentException("The map argument can not contain null key or null value.");
        }
        this.delegate.putAll(t);
        this.notifyAll();
    }

    @Override
    public synchronized V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized Collection<V> values() {
        return this.delegate.values();
    }

    public synchronized V waitFor(Object key, long timeout) {
        if (timeout > 0L) {
            long time = System.currentTimeMillis();
            while (!this.delegate.containsKey(key)) {
                long ellapsed = System.currentTimeMillis() - time;
                if (ellapsed >= timeout) {
                    return null;
                }
                try {
                    this.wait(timeout - ellapsed);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.delegate.get(key);
        }
        if (timeout == 0L) {
            while (!this.delegate.containsKey(key)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.delegate.get(key);
        }
        throw new IllegalArgumentException("Timeout can not be negative.");
    }
}

