/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.util.StringUtils;

public class Version
implements Comparable<Version> {
    private int major = 0;
    private int minor = -1;
    private int patch = -1;
    private String qualifier = "";
    private int build = -1;

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public int getBuild() {
        return this.build;
    }

    public Version(String versionStr) {
        versionStr = StringUtils.deleteWhitespace((String)versionStr);
        String[] fields = StringUtils.split((String)versionStr, (char)'-');
        Preconditions.checkState((fields.length >= 1 ? 1 : 0) != 0);
        String[] parts = StringUtils.split((String)fields[0], (char)'.');
        this.major = Integer.parseInt(parts[0]);
        Preconditions.checkArgument((this.major >= 0 ? 1 : 0) != 0);
        if (parts.length >= 2) {
            this.minor = Integer.parseInt(parts[1]);
            Preconditions.checkArgument((this.minor >= 0 ? 1 : 0) != 0);
        }
        if (parts.length >= 3) {
            this.patch = Integer.parseInt(parts[2]);
            Preconditions.checkArgument((this.patch >= 0 ? 1 : 0) != 0);
        }
        if (parts.length >= 4) {
            throw new RuntimeException("Invalid version string '" + versionStr + "'.");
        }
        if (fields.length >= 2) {
            this.qualifier = fields[1];
        }
        if (fields.length >= 3) {
            this.build = Integer.parseInt(fields[2]);
            Preconditions.checkArgument((this.build >= 0 ? 1 : 0) != 0);
        }
        if (fields.length >= 4) {
            throw new RuntimeException("Invalid version string '" + versionStr + "'.");
        }
    }

    public Version(int major, int minor, int patch, String qualifier, int build) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0, (Object)"Major version should be a positive integer.");
        this.major = major;
        if (minor >= 0) {
            this.minor = minor;
            this.patch = patch;
        } else {
            Preconditions.checkArgument((patch < 0 ? 1 : 0) != 0, (Object)"Minor version should also be specified if patch version is specified.");
        }
        qualifier = qualifier == null ? "" : StringUtils.deleteWhitespace((String)qualifier);
        if (qualifier.length() != 0) {
            this.qualifier = qualifier;
            this.build = build;
        } else {
            Preconditions.checkArgument((build < 0 ? 1 : 0) != 0, (Object)"Qualifier should also be specified if build number is specified.");
        }
    }

    public boolean isCompatible(Version version) {
        return this.major == version.getMajor() && (this.minor < 0 ? 0 : this.minor) == (version.getMinor() < 0 ? 0 : version.getMinor());
    }

    @Override
    public int compareTo(Version version) {
        if (this.major < version.getMajor()) {
            return -1;
        }
        if (this.major > version.getMajor()) {
            return 1;
        }
        if ((this.minor < 0 ? 0 : this.minor) < (version.getMinor() < 0 ? 0 : version.getMinor())) {
            return -1;
        }
        if ((this.minor < 0 ? 0 : this.minor) > (version.getMinor() < 0 ? 0 : version.getMinor())) {
            return 1;
        }
        if ((this.patch < 0 ? 0 : this.patch) < (version.getPatch() < 0 ? 0 : version.getPatch())) {
            return -1;
        }
        if ((this.patch < 0 ? 0 : this.patch) > (version.getPatch() < 0 ? 0 : version.getPatch())) {
            return 1;
        }
        if (!this.qualifier.equals(version.getQualifier())) {
            return this.qualifier.compareTo(version.getQualifier());
        }
        return (this.build < 0 ? 0 : this.build) - (version.getBuild() < 0 ? 0 : version.getBuild());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.major);
        if (this.minor >= 0) {
            buffer.append(".").append(this.minor);
            if (this.patch >= 0) {
                buffer.append(".").append(this.patch);
            }
        }
        if (this.qualifier.length() != 0) {
            buffer.append("-").append(this.qualifier);
            if (this.build >= 0) {
                buffer.append("-").append(this.build);
            }
        }
        return buffer.toString();
    }
}

