/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.AlternatorTool;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.IteratorTool;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;

public class VelocityUtils {
    public static Map<String, Object> TOOLS = new HashMap<String, Object>();

    public static String evalTemplate(String template, Map<String, Object> context, List<String> additionalResourceLoaderPaths) {
        try {
            VelocityContext velocityCtx = VelocityUtils.buildEvalContext(context);
            StringWriter writer = new StringWriter();
            if (additionalResourceLoaderPaths != null && !additionalResourceLoaderPaths.isEmpty()) {
                VelocityEngine ve = new VelocityEngine();
                Properties props = FileUtils.loadProps(new File(Bootstrap.installDir, "asset/velocity.properties"));
                StringBuilder resourceLoaderPaths = new StringBuilder(Bootstrap.installDir.getAbsolutePath() + "/asset");
                for (String additionalResourceLoaderPath : additionalResourceLoaderPaths) {
                    resourceLoaderPaths.append(", ").append(additionalResourceLoaderPath);
                }
                props.setProperty("file.resource.loader.path", resourceLoaderPaths.toString());
                ve.init(props);
                ve.evaluate((Context)velocityCtx, (Writer)writer, "velocity", template);
            } else {
                Velocity.evaluate((Context)velocityCtx, (Writer)writer, (String)"velocity", (String)template);
            }
            return writer.toString();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapException("Failed to evaluate Velocity template.", e);
        }
    }

    public static String evalTemplate(String template, Map<String, Object> context) {
        return VelocityUtils.evalTemplate(template, context, null);
    }

    public static VelocityContext buildEvalContext(Map<String, Object> map) {
        VelocityContext velocityCtx = new VelocityContext(map);
        for (Map.Entry<String, Object> entry : TOOLS.entrySet()) {
            velocityCtx.put(entry.getKey(), entry.getValue());
        }
        return velocityCtx;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alternator", new AlternatorTool());
        map.put("date", new ComparisonDateTool());
        map.put("esc", new EscapeTool());
        map.put("mill", new IteratorTool());
        map.put("lists", new ListTool());
        map.put("math", new MathTool());
        map.put("number", new NumberTool());
        map.put("sorter", new SortTool());
        TOOLS = map;
    }
}

