/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.SimpleCalendar;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@ScriptApi
public class Util {
    @ScriptApi(value="Format duration as H:m:s. The passed param should be milli-seconds.")
    public String formatDuration(long durationMillis) {
        return DateUtils.formatDuration(durationMillis);
    }

    @ScriptApi(value="Format date to be suitable for display in html according to date format setting in QuickBuild. A html space (<em>&nbsp;</em>) will be returned if the date param is null.")
    public String formatDate(Date date) {
        if (date != null) {
            return DateUtils.formatDateTime(date);
        }
        return "&nbsp;";
    }

    @ScriptApi(value="Format specified date using specified pattern.")
    public String formatDate(Date date, String pattern) {
        if (date != null) {
            return new SimpleDateFormat(pattern).format(date);
        }
        return "&nbsp;";
    }

    @ScriptApi(value="Read portion of the file around specified pattern with specified range. The second param should be a Java pattern matching lines of the file, and the third param should be a range indicating how many lines (both before and after) around the matched line should be read.")
    public String readFileAsString(File file, String pattern, int range) {
        return FileUtils.readFileAsString(file, pattern, range);
    }

    @ScriptApi(value="Read file content as string.")
    public String readFileAsString(File file) {
        return FileUtils.readFileAsString(file);
    }

    @ScriptApi(value="Format specified string to be suitable for display in html. The line break character will be replaced with <em>&lt;br&gt;</em>. Null string is acceptable and <em>&nbsp;</em> will be returned in that case.")
    public String formatString(String string) {
        if (string != null) {
            return StringUtils.formatAsHtml(string);
        }
        return "&nbsp;";
    }

    @ScriptApi(value="Format error message to be suitable for display in html. If the message is of multiple lines, second lines will be padded with white spaces at the beginning.")
    @Deprecated
    public String formatErrorMessage(String errorMessage) {
        throw new QuickbuildException("util.formatErrorMessage() is deprecated, please use util.formatString() instead.");
    }

    @ScriptApi(value="Encrypt specified string. Null will be returned if a null string is passed as parameter.")
    public String encrypt(String plain) {
        return StringUtils.encrypt(plain);
    }

    @ScriptApi(value="Decrypt specified string. Null will be returned if a null string is passed as parameter.")
    public String decrypt(String secret) {
        return StringUtils.decrypt(secret);
    }

    @ScriptApi(value="Get calendar object from which year, month and day can be retrieved.")
    public SimpleCalendar getCalendar() {
        return new SimpleCalendar();
    }

    @ScriptApi(value="Execute specified command and get the output. Multiple lines of output are separated by line terminators. The string param is the command to execute. The command should be composed of an executable part and optionally several parameters part separated by spaces. If the execution part or param parts themselves contain spaces, they should be quoted. For example: <em>util.readOutput(\"/path/to/command \\\"param1 with space\\\" \\\"param2 with space\\\"\")</em>")
    public String readOutput(String command) {
        return this.readOutput(command, null);
    }

    @ScriptApi(value="Execute specified command and get the output. The first param is the command to execute, and the second param is working directory of the command. The command should be composed of an executable part and optionally several parameters part separated by spaces. If the execution part or param parts themselves contain spaces, they should be quoted. For example: <em>util.readOutput(\"/path/to/command \\\"param1 with space\\\" \\\"param2 with space\\\"\")</em>")
    public String readOutput(String command, File workingDir) {
        Commandline cmdline = new Commandline(command);
        final StringBuffer buffer = new StringBuffer();
        cmdline.execute(workingDir, (OutputStream)new LineConsumer(){

            @Override
            public void consume(String line) {
                Context.getLogger().debug(line);
                buffer.append(line);
                buffer.append("\n");
            }
        }, (LineConsumer)new LineConsumer.WarnLogger()).checkReturnCode();
        return buffer.toString().trim();
    }

    @ScriptApi(value="Execute specified command and get the command return code. The string param is the command to execute. The command should be composed of an executable part and optionally several parameters part separated by spaces. If the execution part or param parts themselves contain spaces, they should be quoted. For example: <em>util.execute(\"/path/to/command \\\"param1 with space\\\" \\\"param2 with space\\\"\")</em>")
    public int execute(String command) {
        return this.execute(command, null);
    }

    @ScriptApi(value="Execute specified command and get the command return code. The first param is the command to execute and the second param is the working directory for the command. The command should be composed of an executable part and optionally several parameters part separated by spaces. If the execution part or param parts themselves contain spaces, they should be quoted. For example: <em>util.execute(\"/path/to/command \\\"param1 with space\\\" \\\"param2 with space\\\"\")</em>")
    public int execute(String command, File workingDir) {
        Commandline cmdline = new Commandline(command);
        return cmdline.execute(workingDir, (OutputStream)new LineConsumer.DebugLogger(), (LineConsumer)new LineConsumer.WarnLogger()).getReturnCode();
    }

    @ScriptApi(value="Get file object of specified path")
    public File getFile(String path) {
        return new File(path);
    }

    @ScriptApi(value="Delete specified directory.")
    public void deleteDir(File dir) {
        FileUtils.deleteDir(dir);
    }

    @ScriptApi(value="Delete specified file.")
    public void deleteFile(File file) {
        FileUtils.deleteFile(file);
    }

    @ScriptApi(value="Delete files matching specified patterns (2nd param) from specified directory (1st param). Refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    public void deleteFiles(File dir, String patterns) {
        FileUtils.deleteFiles(dir, patterns);
    }

    @ScriptApi(value="Clean specified directory.")
    public void cleanDir(File dir) {
        FileUtils.cleanDir(dir);
    }

    @ScriptApi(value="Join values of specified collection with comma character.")
    public String join(Collection<String> collection) {
        return StringUtils.join(collection);
    }

    @ScriptApi(value="Split specified string into a list of strings using new line or comma character as separator.")
    public List<String> split(String joined) {
        return StringUtils.splitAndTrim(joined);
    }

    @ScriptApi(value="Copy file. The first argument represents the file to be copied, and the second argument represents the destination file.")
    public void copyFile(File from, File to) {
        FileUtils.copyFile(from, to);
    }

    @ScriptApi(value="Copy directory. The first argument represents the directory to be copied, and the second argument represents the destination directory.")
    public void copyDir(File from, File to) {
        FileUtils.copyDir(from, to);
    }

    @ScriptApi(value="Assign an unique integer identifier for path of specified file.")
    public Long assignIdFor(File file) {
        return FileUtils.assignIdFor(file);
    }

    @ScriptApi(value="Convert an object to string.")
    public String obj2string(Serializable obj) {
        return StringUtils.obj2string(obj);
    }

    @ScriptApi(value="Convert a string to object.")
    public Serializable string2obj(String string) {
        return StringUtils.string2obj(string);
    }
}

