/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class UpgradableReadWriteLock
implements ReadWriteLock {
    private ReadWriteLock lock;
    private ThreadLocal<Integer> readCountHolder = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private ThreadLocal<Integer> writeCountHolder = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public UpgradableReadWriteLock(ReadWriteLock lock) {
        this.lock = lock;
    }

    @Override
    public Lock readLock() {
        return new Lock(){

            @Override
            public void lock() {
                UpgradableReadWriteLock.this.lock.readLock().lock();
                if ((Integer)UpgradableReadWriteLock.this.writeCountHolder.get() == 0) {
                    UpgradableReadWriteLock.this.readCountHolder.set((Integer)UpgradableReadWriteLock.this.readCountHolder.get() + 1);
                }
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Condition newCondition() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean tryLock() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void unlock() {
                UpgradableReadWriteLock.this.lock.readLock().unlock();
                if ((Integer)UpgradableReadWriteLock.this.writeCountHolder.get() == 0) {
                    UpgradableReadWriteLock.this.readCountHolder.set((Integer)UpgradableReadWriteLock.this.readCountHolder.get() - 1);
                }
            }
        };
    }

    @Override
    public Lock writeLock() {
        return new Lock(){

            @Override
            public void lock() {
                if ((Integer)UpgradableReadWriteLock.this.writeCountHolder.get() == 0) {
                    for (int i = 0; i < (Integer)UpgradableReadWriteLock.this.readCountHolder.get(); ++i) {
                        UpgradableReadWriteLock.this.lock.readLock().unlock();
                    }
                }
                UpgradableReadWriteLock.this.lock.writeLock().lock();
                UpgradableReadWriteLock.this.writeCountHolder.set((Integer)UpgradableReadWriteLock.this.writeCountHolder.get() + 1);
            }

            @Override
            public void lockInterruptibly() throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Condition newCondition() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean tryLock() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void unlock() {
                UpgradableReadWriteLock.this.writeCountHolder.set((Integer)UpgradableReadWriteLock.this.writeCountHolder.get() - 1);
                if ((Integer)UpgradableReadWriteLock.this.writeCountHolder.get() == 0) {
                    for (int i = 0; i < (Integer)UpgradableReadWriteLock.this.readCountHolder.get(); ++i) {
                        UpgradableReadWriteLock.this.lock.readLock().lock();
                    }
                }
                UpgradableReadWriteLock.this.lock.writeLock().unlock();
            }
        };
    }
}

