/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TimeUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long FIVE_MINUTE = 300000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long SIX_HOUR = 21600000L;

    public static long nowUnixTime() {
        return TimeUtils.toUnixTime(System.currentTimeMillis());
    }

    public static long toUnixTime(long millisSinceEpoch) {
        return TimeUnit.MILLISECONDS.toSeconds(millisSinceEpoch);
    }

    public static Date unixTimeToDate(long epoch) {
        return new DateTime(TimeUnit.SECONDS.toMillis(epoch), DateTimeZone.UTC).toDate();
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public static long ago(long duration) {
        return TimeUtils.ago(TimeUtils.now(), duration);
    }

    public static long ago(long now, long duration) {
        return now - duration;
    }

    public static long plus(long now, long duration) {
        return now + duration;
    }

    public static long minus(long now, long duration) {
        return now - duration;
    }

    public static long roundDownTime(long approxTime, long interval) {
        return approxTime - approxTime % interval;
    }

    public static long closestTime(long approxTime, long interval) {
        long mod = approxTime % interval;
        if (mod > interval / 2L) {
            approxTime += interval;
        }
        return approxTime - mod;
    }
}

