/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.ant.types.resources.ArchiveResource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.TarResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

class Tar
extends MatchingTask {
    private static final int BUFFER_SIZE = 65536;
    OutputStream delegate;
    private Vector resourceCollections = new Vector();
    private boolean compression = false;

    Tar() {
    }

    public void setOutputStream(final OutputStream out) {
        this.delegate = new OutputStream(){

            @Override
            public void write(int data) throws IOException {
                out.write(data);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                out.write(b, off, len);
            }

            @Override
            public void write(byte[] b) throws IOException {
                out.write(b);
            }
        };
    }

    public void add(ResourceCollection res) {
        this.resourceCollections.add(res);
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public void execute() throws BuildException {
        if (this.resourceCollections.size() == 0) {
            throw new BuildException("You must supply some nested resource collections.", this.getLocation());
        }
        TarOutputStream tOut = null;
        try {
            tOut = this.compression ? new TarOutputStream((OutputStream)new GZIPOutputStream(this.delegate)) : new TarOutputStream(this.delegate);
            tOut.setDebug(true);
            tOut.setLongFileMode(2);
            Enumeration e = this.resourceCollections.elements();
            while (e.hasMoreElements()) {
                this.tar((ResourceCollection)e.nextElement(), tOut);
            }
        }
        catch (IOException ioe) {
            try {
                String msg = "Problem creating TAR: " + ioe.getMessage();
                throw new BuildException(msg, (Throwable)ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tOut);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)tOut);
    }

    protected void tarFile(File file, TarOutputStream tOut, String vPath, Tar.TarFileSet tarFileSet) throws IOException {
        this.tarResource((Resource)new FileResource(file), tOut, vPath, tarFileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tarResource(Resource r, TarOutputStream tOut, String vPath, Tar.TarFileSet tarFileSet) throws IOException {
        if (!r.isExists()) {
            return;
        }
        if (tarFileSet != null) {
            String fullpath = tarFileSet.getFullpath(this.getProject());
            if (fullpath.length() > 0) {
                vPath = fullpath;
            } else {
                if (vPath.length() <= 0) {
                    return;
                }
                String prefix = tarFileSet.getPrefix(this.getProject());
                if (prefix.length() > 0 && !prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                vPath = prefix + vPath;
            }
            if (vPath.startsWith("/")) {
                int l = vPath.length();
                if (l <= 1) {
                    return;
                }
                vPath = vPath.substring(1, l);
            }
        }
        if (r.isDirectory() && !vPath.endsWith("/")) {
            vPath = vPath + "/";
        }
        TarEntry te = new TarEntry(vPath);
        te.setModTime(r.getLastModified());
        if (r instanceof ArchiveResource) {
            ArchiveResource ar = (ArchiveResource)r;
            te.setMode(ar.getMode());
            if (r instanceof TarResource) {
                TarResource tr = (TarResource)r;
                te.setUserName(tr.getUserName());
                te.setUserId(tr.getUid());
                te.setGroupName(tr.getGroup());
                te.setGroupId(tr.getGid());
            }
        }
        if (!r.isDirectory()) {
            if ((long)r.size() > 0x1FFFFFFFFL) {
                throw new BuildException("Resource: " + r + " larger than " + 0x1FFFFFFFFL + " bytes.");
            }
            te.setSize(r.getSize());
        } else if (tarFileSet != null && tarFileSet.hasDirModeBeenSet()) {
            te.setMode(tarFileSet.getDirMode(this.getProject()));
        }
        if (tarFileSet != null) {
            if (tarFileSet.hasUserNameBeenSet()) {
                te.setUserName(tarFileSet.getUserName());
            }
            if (tarFileSet.hasGroupBeenSet()) {
                te.setGroupName(tarFileSet.getGroup());
            }
            if (tarFileSet.hasUserIdBeenSet()) {
                te.setUserId(tarFileSet.getUid());
            }
            if (tarFileSet.hasGroupIdBeenSet()) {
                te.setGroupId(tarFileSet.getGid());
            }
        }
        InputStream in = null;
        try {
            tOut.putNextEntry(te);
            if (!r.isDirectory()) {
                in = r.getInputStream();
                byte[] buffer = new byte[65536];
                int count = 0;
                do {
                    tOut.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
            tOut.closeEntry();
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close((InputStream)in);
    }

    protected void tar(ResourceCollection rc, TarOutputStream tOut) throws IOException {
        ArchiveFileSet afs = null;
        if (rc instanceof ArchiveFileSet) {
            afs = (ArchiveFileSet)rc;
        }
        if (afs != null && afs.size() > 1 && afs.getFullpath(this.getProject()).length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        Tar.TarFileSet tfs = this.asTarFileSet(afs);
        if (Tar.isFileFileSet(rc)) {
            FileSet fs = (FileSet)rc;
            String[] files = Tar.getFileNames(fs);
            for (int i = 0; i < files.length; ++i) {
                File f = new File(fs.getDir(this.getProject()), files[i]);
                String name = files[i].replace(File.separatorChar, '/');
                this.tarFile(f, tOut, name, tfs);
            }
        } else if (rc.isFilesystemOnly()) {
            for (FileResource r : rc) {
                File f = r.getFile();
                if (f == null) {
                    f = new File(r.getBaseDir(), r.getName());
                }
                this.tarFile(f, tOut, f.getName(), tfs);
            }
        } else {
            for (Resource r : rc) {
                this.tarResource(r, tOut, r.getName(), tfs);
            }
        }
    }

    protected static final boolean isFileFileSet(ResourceCollection rc) {
        return rc instanceof FileSet && rc.isFilesystemOnly();
    }

    protected static final String[] getFileNames(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(fs.getProject());
        String[] directories = ds.getIncludedDirectories();
        String[] filesPerSe = ds.getIncludedFiles();
        String[] files = new String[directories.length + filesPerSe.length];
        System.arraycopy(directories, 0, files, 0, directories.length);
        System.arraycopy(filesPerSe, 0, files, directories.length, filesPerSe.length);
        return files;
    }

    protected Tar.TarFileSet asTarFileSet(ArchiveFileSet archiveFileSet) {
        Tar.TarFileSet tfs = null;
        if (archiveFileSet != null && archiveFileSet instanceof Tar.TarFileSet) {
            tfs = (Tar.TarFileSet)archiveFileSet;
        } else {
            tfs = new Tar.TarFileSet();
            tfs.setProject(this.getProject());
            if (archiveFileSet != null) {
                tfs.setPrefix(archiveFileSet.getPrefix(this.getProject()));
                tfs.setFullpath(archiveFileSet.getFullpath(this.getProject()));
                if (archiveFileSet.hasFileModeBeenSet()) {
                    tfs.integerSetFileMode(archiveFileSet.getFileMode(this.getProject()));
                }
                if (archiveFileSet.hasDirModeBeenSet()) {
                    tfs.integerSetDirMode(archiveFileSet.getDirMode(this.getProject()));
                }
                if (archiveFileSet instanceof TarFileSet) {
                    TarFileSet t = (TarFileSet)archiveFileSet;
                    if (t.hasUserNameBeenSet()) {
                        tfs.setUserName(t.getUserName());
                    }
                    if (t.hasGroupBeenSet()) {
                        tfs.setGroup(t.getGroup());
                    }
                    if (t.hasUserIdBeenSet()) {
                        tfs.setUid(t.getUid());
                    }
                    if (t.hasGroupIdBeenSet()) {
                        tfs.setGid(t.getGid());
                    }
                }
            }
        }
        return tfs;
    }
}

