/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.hibernate.util.SerializationHelper;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    public static List<String> splitAndTrim(String joinedValues, String separators) {
        String[] values = StringUtils.split((String)joinedValues, (String)separators);
        ArrayList<String> trimedValues = new ArrayList<String>();
        for (String value : values) {
            String trimedValue = value.trim();
            if (trimedValue.length() == 0) continue;
            trimedValues.add(trimedValue);
        }
        return trimedValues;
    }

    public static List<String> splitAndTrim(String joinedValues, char separator) {
        return StringUtils.splitAndTrim(joinedValues, String.valueOf(separator));
    }

    public static List<String> splitAndTrim(String joinedValues) {
        return StringUtils.splitAndTrim(joinedValues, ",\n");
    }

    public static String join(Iterator<String> iterator) {
        return StringUtils.join(iterator, (String)",");
    }

    public static String join(Collection<String> collection) {
        return StringUtils.join(collection, (String)",");
    }

    public static String[] parseQuoteTokens(String string) {
        ArrayList<String> commandTokens = new ArrayList<String>();
        StreamTokenizer st = new StreamTokenizer(new BufferedReader(new StringReader(string)));
        st.resetSyntax();
        st.wordChars(0, 255);
        st.ordinaryChar(32);
        st.ordinaryChar(10);
        st.ordinaryChar(9);
        st.ordinaryChar(13);
        st.quoteChar(34);
        try {
            String token = null;
            while (st.nextToken() != -1) {
                if (st.ttype == 34 || st.ttype == -3) {
                    if (token == null) {
                        token = st.sval;
                        continue;
                    }
                    token = token + st.sval;
                    continue;
                }
                if (token == null) continue;
                commandTokens.add(token);
                token = null;
            }
            if (token != null) {
                commandTokens.add(token);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return commandTokens.toArray(new String[commandTokens.size()]);
    }

    public static String simpleInterpolate(String string, Map<Object, Object> variables) {
        return MapVariableInterpolator.interpolate((String)string, variables);
    }

    public static String encrypt(String string) {
        return BootstrapUtils.encrypt((String)string);
    }

    public static String encrypt(String string, String secretKey) {
        if (string == null) {
            return null;
        }
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(secretKey.getBytes("UTF8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            SecretKey key = keyFactory.generateSecret(keySpec);
            cipher.init(1, key);
            byte[] ciphertext = cipher.doFinal(string.getBytes("UTF8"));
            return new String(Base64.encodeBase64((byte[])ciphertext));
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public static String decrypt(String string, String secretKey) {
        if (string == null) {
            return null;
        }
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(secretKey.getBytes("UTF8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            SecretKey key = keyFactory.generateSecret(keySpec);
            cipher.init(2, key);
            byte[] bytes = cipher.doFinal(Base64.decodeBase64((byte[])string.getBytes()));
            return new String(bytes, "UTF8");
        }
        catch (Exception e) {
            throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    public static String decrypt(String string) {
        return BootstrapUtils.decrypt((String)string);
    }

    public static String formatByteCount(long byteCount) {
        return FileUtils.byteCountToDisplaySize((long)byteCount);
    }

    public static String formatAsHtml(String string) {
        String escaped = StringEscapeUtils.escapeHtml((String)string);
        escaped = StringUtils.replace((String)escaped, (String)"\n", (String)"<br>");
        escaped = StringUtils.replace((String)escaped, (String)"\t", (String)"&nbsp;&nbsp;&nbsp;&nbsp;");
        char[] buffer = escaped.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != '\u0000') continue;
            buffer[i] = 32;
        }
        return new String(buffer);
    }

    public static int compareVersion(String version1, String version2) {
        return StringUtils.normalisedVersion(version1).compareTo(StringUtils.normalisedVersion(version2));
    }

    private static String normalisedVersion(String version) {
        String[] parts = StringUtils.split((String)version, (String)".");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            sb.append(String.format("%4s", part));
        }
        return sb.toString();
    }

    public static String hash(String plain) {
        return BootstrapUtils.hash((String)plain);
    }

    public static String bytes2string(byte[] bytes) {
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static byte[] string2bytes(String string) {
        return Base64.decodeBase64((byte[])string.getBytes());
    }

    public static String obj2string(Serializable obj) {
        return StringUtils.bytes2string(SerializationHelper.serialize(obj));
    }

    public static Serializable string2obj(String string) {
        return (Serializable)SerializationHelper.deserialize(StringUtils.string2bytes(string));
    }

    private static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    private static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    private static String[] toStringArray(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static boolean matchPath(String pattern, String path) {
        return StringUtils.doMatch(pattern, path, true);
    }

    private static boolean doMatch(String pattern, String path, boolean fullMatch) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith("/") != pattern.startsWith("/")) {
            return false;
        }
        String[] pattDirs = StringUtils.tokenizeToStringArray(pattern, "/");
        String[] pathDirs = StringUtils.tokenizeToStringArray(path, "/");
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (StringUtils.matchStrings(patDir, pathDirs[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith("/") ? path.endsWith("/") : !path.endsWith("/");
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith("/")) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!StringUtils.matchStrings(patDir, pathDirs[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!StringUtils.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    private static boolean matchStrings(String pattern, String str) {
        char ch;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == strArr[i]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (patArr[i] != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i + j]) continue block8;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }
}

