/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.annotation.ScriptApi;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

@ScriptApi(value="A simple calendar object.")
public class SimpleCalendar {
    @ScriptApi(value="Get day of month. Possible values are from 01 to 31.")
    public String getDayOfMonth() {
        int value = Calendar.getInstance().get(5);
        String dayOfMonth = value < 10 ? "0" + value : String.valueOf(value);
        return dayOfMonth;
    }

    @ScriptApi(value="Get day of week, for example: Mon, Sat.")
    public String getDayOfWeek() {
        return new DateFormatSymbols(Locale.US).getShortWeekdays()[Calendar.getInstance().get(7)];
    }

    @ScriptApi(value="Get numeric day of week. Possible values are from 1 to 7.")
    public String getNumericDayOfWeek() {
        return String.valueOf(Calendar.getInstance().get(7) - 1);
    }

    @ScriptApi(value="Get day of year, possible values are from 1 to 365.")
    public String getDayOfYear() {
        return String.valueOf(Calendar.getInstance().get(6));
    }

    @ScriptApi(value="Get hour. Possible values are from 00 to 23")
    public String getHour() {
        int value = Calendar.getInstance().get(11);
        String hour = value < 10 ? "0" + value : String.valueOf(value);
        return hour;
    }

    @ScriptApi(value="Get hour of half day. Possible values are from 0 to 11")
    public String getHourOfHalfDay() {
        return String.valueOf(Calendar.getInstance().get(10));
    }

    @ScriptApi(value="Get am/pm of the day. Possible values are am and pm")
    public String getAMPM() {
        int ampm = Calendar.getInstance().get(9);
        if (ampm == 0) {
            return "am";
        }
        return "pm";
    }

    @ScriptApi(value="Get minute. Possible values are from 00 to 59.")
    public String getMinute() {
        int value = Calendar.getInstance().get(12);
        String minute = value < 10 ? "0" + value : String.valueOf(value);
        return minute;
    }

    @ScriptApi(value="Get second. Possible values are from 00 to 59.")
    public String getSecond() {
        int value = Calendar.getInstance().get(13);
        String second = value < 10 ? "0" + value : String.valueOf(value);
        return second;
    }

    @ScriptApi(value="Get month. For example: Jan, Feb.")
    public String getMonth() {
        return new DateFormatSymbols(Locale.US).getShortMonths()[Calendar.getInstance().get(2)];
    }

    @ScriptApi(value="Get numeric month. Possible values are from 01 to 12.")
    public String getNumericMonth() {
        int value = Calendar.getInstance().get(2) + 1;
        String numericMonth = value < 10 ? "0" + value : String.valueOf(value);
        return numericMonth;
    }

    @ScriptApi(value="Get week of year. For example: 1, 2.")
    public String getWeekOfYear() {
        return String.valueOf(Calendar.getInstance().get(3));
    }

    @ScriptApi(value="Get year. For example, 2005, 2006.")
    public String getYear() {
        return String.valueOf(Calendar.getInstance().get(1));
    }

    @ScriptApi(value="Get short year. For example: 05, 06.")
    public String getShortYear() {
        return String.valueOf(Calendar.getInstance().get(1)).substring(2);
    }
}

