/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtils {
    private static final Logger logger = LoggerFactory.getLogger(ServletUtils.class);

    public static void download(String url, String token, File saveAs) {
        ServletUtils.download(url, token, saveAs, 300);
    }

    public static void download(String url, String token, File saveAs, int timeout) {
        InputStream is = null;
        BufferedOutputStream bos = null;
        try {
            int count;
            is = ServletUtils.download(url, token, timeout);
            byte[] data = new byte[65536];
            bos = new BufferedOutputStream(new FileOutputStream(saveAs), 65536);
            while ((count = is.read(data)) > -1) {
                ((OutputStream)bos).write(data, 0, count);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)bos);
    }

    public static InputStream download(String url, String token) {
        return ServletUtils.download(url, token, 300);
    }

    public static InputStream download(String url, String token, int timeout) {
        HttpURLConnection urlConn = null;
        try {
            urlConn = (HttpURLConnection)new URL(url).openConnection();
            urlConn.setConnectTimeout(120000);
            urlConn.setReadTimeout(timeout * 1000);
            if (token != null) {
                byte[] encoded = Base64.encodeBase64((byte[])token.getBytes());
                urlConn.setRequestProperty("Authorization", "Basic " + new String(encoded));
            }
            long start = System.currentTimeMillis();
            while (true) {
                try {
                    return urlConn.getInputStream();
                }
                catch (Exception e) {
                    if (e instanceof ConnectException || e instanceof SocketTimeoutException) {
                        if (System.currentTimeMillis() - start > (long)urlConn.getConnectTimeout() || e.getMessage() != null && e.getMessage().toLowerCase().contains("refused")) {
                            throw new QuickbuildException("Can not connect to '" + urlConn.getURL() + "'.", (Throwable)e);
                        }
                    } else {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    logger.warn("Connecting to '" + urlConn.getURL() + "' failed: " + e.getMessage() + ", retrying...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e2) {}
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw ServletUtils.wrapException(urlConn, e);
        }
    }

    public static void download(String url, String userName, String password, File saveAs) {
        if (userName != null) {
            ServletUtils.download(url, userName + ":" + password, saveAs);
        } else {
            ServletUtils.download(url, null, saveAs);
        }
    }

    public static InputStream download(String url, String userName, String password) {
        if (userName != null) {
            return ServletUtils.download(url, userName + ":" + password);
        }
        return ServletUtils.download(url, null);
    }

    public static void serve(File file, String mimeType, HttpServletResponse response) {
        String encodedFileName;
        if (StringUtils.isBlank((String)mimeType)) {
            response.setContentType("application/octet-stream");
            response.setHeader("X-Content-Type-Options", "nosniff");
        } else {
            response.setContentType(mimeType);
        }
        try {
            encodedFileName = URLEncoder.encode(file.getName(), "UTF-8");
            encodedFileName = StringUtils.replace((String)encodedFileName, (String)"+", (String)"%20");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        response.setHeader("Content-Disposition", "inline;filename*=UTF-8''" + encodedFileName);
        FileInputStream is = null;
        try {
            int count;
            long fileSize = file.length();
            if (fileSize > 2000000000L) {
                response.setContentLength(-1);
            } else {
                response.setContentLength((int)fileSize);
            }
            is = new FileInputStream(file);
            byte[] data = new byte[65536];
            ServletOutputStream os = response.getOutputStream();
            while ((count = ((InputStream)is).read(data)) != -1) {
                os.write(data, 0, count);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public static String getLineSeparator(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (userAgent == null) {
            return "\n";
        }
        if (userAgent.matches(".*Windows.*")) {
            return "\r\n";
        }
        return "\n";
    }

    public static RuntimeException wrapException(HttpURLConnection conn, IOException e) {
        if (conn != null) {
            InputStream es = conn.getErrorStream();
            String errorMsg = null;
            if (es != null) {
                try {
                    errorMsg = IOUtils.toString((InputStream)es);
                }
                catch (IOException e2) {
                    // empty catch block
                }
                IOUtils.closeQuietly((InputStream)es);
            }
            if (errorMsg != null) {
                return new QuickbuildException(errorMsg);
            }
            return new RuntimeException(e);
        }
        return new RuntimeException(e);
    }

    public static void serve(byte[] data, String mimeType, String fileName, HttpServletResponse response) {
        String encodedFileName;
        response.setContentType(mimeType);
        try {
            encodedFileName = URLEncoder.encode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        response.setHeader("Content-Disposition", "inline;filename*=UTF-8''" + encodedFileName);
        try {
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSecureRequest(HttpServletRequest request) {
        try {
            String forwardProtocol = request.getHeader("X-Forwarded-Proto");
            if (forwardProtocol != null) {
                return "https".equals(forwardProtocol);
            }
            return "https".equals(new URL(request.getRequestURL().toString()).getProtocol());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

