/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class RingBuffer<T> {
    private final int indexMask;
    private final Object[] entries;
    private final EventFactory<T> eventFactory;
    protected AtomicLong sequence = new AtomicLong(-1L);

    public RingBuffer(EventFactory<T> factory, int bufferSize) {
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.eventFactory = factory;
        this.indexMask = bufferSize - 1;
        this.entries = new Object[bufferSize];
        this.fill();
    }

    public T get(long seq) {
        return (T)this.entries[(int)seq & this.indexMask];
    }

    public long getCursor() {
        return this.sequence.get();
    }

    public List<T> getLastN(int n) {
        long cur = this.getCursor();
        if (n > this.entries.length) {
            n = this.entries.length;
        }
        if ((long)n > cur + 1L) {
            n = (int)cur + 1;
        }
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(this.get(cur - (long)i));
        }
        return list;
    }

    public T getLast() {
        return this.get(this.getCursor());
    }

    public void publish(long sequence) {
    }

    public long next() {
        return this.sequence.incrementAndGet();
    }

    private void fill() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = this.eventFactory.newInstance();
        }
    }

    public static interface EventFactory<T> {
        public T newInstance();
    }
}

