/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.util.ClassUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ResourceUtils {
    public static URL getResourceUrl(Class scope, String path) {
        return scope.getClassLoader().getResource(ResourceUtils.getResourcePath(scope, path));
    }

    public static String getResourcePath(Class scope, String path) {
        String packageName = StringUtils.substringBeforeLast((String)scope.getName(), (String)".");
        String packagePath = StringUtils.replace((String)packageName, (String)".", (String)"/");
        String relativePath = StringUtils.stripStart((String)path, (String)"/");
        return packagePath + "/" + relativePath;
    }

    public static Properties loadProperties(Class scope, String path) {
        Properties properties;
        InputStream is = null;
        try {
            is = scope.getClassLoader().getResourceAsStream(ResourceUtils.getResourcePath(scope, path));
            Properties props = new Properties();
            props.load(is);
            properties = props;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return properties;
    }

    public static boolean isExternalAsset(String assetPath) {
        return assetPath.startsWith("/asset");
    }

    public static File getExternalAsset(String externalAssetPath) {
        return new File(Bootstrap.installDir, externalAssetPath);
    }

    public static long getLastModified(String assetPath) {
        if (ResourceUtils.isExternalAsset(assetPath)) {
            return ResourceUtils.getExternalAsset(assetPath).lastModified();
        }
        File file = ClassUtils.getClassFile(Quickbuild.class);
        try {
            if (file.isDirectory()) {
                return new File(file, "asset" + assetPath).lastModified();
            }
            URL url = Quickbuild.class.getClassLoader().getResource("asset" + assetPath);
            if (url == null) {
                throw new QuickbuildException("Unable to find asset: " + assetPath);
            }
            return url.openConnection().getLastModified();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream getAssetStream(String assetPath) {
        File file = ClassUtils.getClassFile(Quickbuild.class);
        try {
            if (file.isDirectory()) {
                return new FileInputStream(new File(file, "asset" + assetPath));
            }
            URL url = Quickbuild.class.getClassLoader().getResource("asset" + assetPath);
            if (url == null) {
                throw new QuickbuildException("Unable to find asset: " + assetPath);
            }
            return url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getAssetLength(String assetPath) {
        if (ResourceUtils.isExternalAsset(assetPath)) {
            return new File(Bootstrap.installDir, assetPath).length();
        }
        File file = ClassUtils.getClassFile(Quickbuild.class);
        try {
            if (file.isDirectory()) {
                return new File(file, "asset" + assetPath).length();
            }
            URL url = Quickbuild.class.getClassLoader().getResource("asset" + assetPath);
            if (url == null) {
                throw new QuickbuildException("Unable to find asset: " + assetPath);
            }
            return url.openConnection().getContentLength();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

