/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

public enum OsType {
    WINDOWS("Windows"),
    LINUX("Linux"),
    OSX("Mac OS X"),
    SOLARIS("Solaris"),
    BSD("BSD"),
    AIX("Aix"),
    HPUX("HP UX"),
    JAVA("Any");

    final String displayName;

    private OsType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static OsType fromOsName(String osName) {
        if (osName.indexOf("windows") > -1) {
            return WINDOWS;
        }
        if (osName.indexOf("linux") > -1) {
            return LINUX;
        }
        if (osName.indexOf("solaris") > -1 || osName.indexOf("sunos") > -1) {
            return SOLARIS;
        }
        if (osName.indexOf("bsd") > -1) {
            return BSD;
        }
        if (osName.indexOf("aix") > -1) {
            return AIX;
        }
        if (osName.indexOf("hp-ux") > -1) {
            return HPUX;
        }
        if (osName.indexOf("mac") > -1) {
            return OSX;
        }
        return JAVA;
    }
}

