/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.util.Collection;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.HtmlEmail;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.slf4j.Logger;

public class MiscUtils {
    public static Project createAntProject() {
        return MiscUtils.createAntProject(null);
    }

    public static Project createAntProject(final Logger logger) {
        Project antProject = new Project();
        antProject.init();
        if (logger != null) {
            antProject.addBuildListener(new BuildListener(){

                public void buildStarted(BuildEvent event) {
                }

                public void buildFinished(BuildEvent event) {
                }

                public void targetStarted(BuildEvent event) {
                }

                public void targetFinished(BuildEvent event) {
                }

                public void taskStarted(BuildEvent event) {
                }

                public void taskFinished(BuildEvent event) {
                }

                public void messageLogged(BuildEvent event) {
                    if (event.getPriority() == 0) {
                        logger.error(event.getMessage());
                    } else if (event.getPriority() == 1) {
                        logger.warn(event.getMessage());
                    } else if (event.getPriority() == 2) {
                        logger.info(event.getMessage());
                    } else {
                        logger.debug(event.getMessage());
                    }
                }
            });
        }
        return antProject;
    }

    public static void sendMail(String toList, String ccList, String bccList, String subject, String body, Collection<File> attachments, EmailSetting emailSetting, String mimeType) {
        try {
            HtmlEmail email = new HtmlEmail();
            email.setSocketConnectionTimeout(120000);
            if (emailSetting.getTimeout() != 0) {
                email.setSocketTimeout(emailSetting.getTimeout() * 1000);
            }
            if (emailSetting.isEnableStartTLS()) {
                email.setStartTLSEnabled(true);
            }
            email.setSSLCheckServerIdentity(false);
            String senderEmail = emailSetting.getSenderAddress();
            if (senderEmail == null) {
                senderEmail = "quickbuild@" + Bootstrap.getHostName();
            }
            email.setFrom(senderEmail);
            if (emailSetting.getReplyAddress() != null) {
                email.addReplyTo(emailSetting.getReplyAddress());
            }
            if (StringUtils.isNotBlank((String)toList)) {
                for (String each : StringUtils.splitAndTrim(toList)) {
                    email.addTo(each);
                }
            }
            if (StringUtils.isNotBlank((String)ccList)) {
                for (String each : StringUtils.splitAndTrim(ccList)) {
                    email.addCc(each);
                }
            }
            if (StringUtils.isNotBlank((String)bccList)) {
                for (String each : StringUtils.splitAndTrim(bccList)) {
                    email.addBcc(each);
                }
            }
            email.setHostName(emailSetting.getSmtpHost());
            email.setSmtpPort(emailSetting.getSmtpPort());
            email.setSslSmtpPort(String.valueOf(emailSetting.getSslSmtpPort()));
            email.setSSLOnConnect(emailSetting.isSmtpOverSSL());
            String smtpUser = emailSetting.getSmtpUser();
            if (smtpUser != null) {
                email.setAuthentication(smtpUser, emailSetting.getSmtpPassword());
            }
            email.setCharset("UTF-8");
            email.setSubject(subject);
            email.setHtmlMsg(body);
            if (attachments != null) {
                for (File file : attachments) {
                    EmailAttachment attachment = new EmailAttachment();
                    attachment.setURL(file.toURI().toURL());
                    attachment.setDisposition("attachment");
                    attachment.setDescription(file.getName());
                    attachment.setName(file.getName());
                    email.attach(attachment);
                }
            }
            Context.getLogger().debug("Sending email to: " + toList);
            email.send();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public static void sendMail(String toList, String ccList, String subject, String body, Collection<File> attachments, EmailSetting emailSetting, String mimeType) {
        MiscUtils.sendMail(toList, ccList, null, subject, body, attachments, emailSetting, mimeType);
    }
}

