/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.util.UpgradableReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.ReferenceMap;

public class LockUtils {
    public static final Map<String, Lock> locks = new ReferenceMap(0, 2);
    public static final Map<String, ReadWriteLock> readWriteLocks = new ReferenceMap(0, 2);

    public static Lock lock(String name) {
        return LockUtils.lock(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock lock(String name, boolean tryMode) {
        Lock lock;
        Map<String, Lock> map = locks;
        synchronized (map) {
            lock = locks.get(name);
            if (lock == null) {
                lock = new ReentrantLock();
                locks.put(name, lock);
            }
        }
        if (tryMode) {
            if (lock.tryLock()) {
                return lock;
            }
            return null;
        }
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return lock;
    }

    public static Lock lock(File file) {
        try {
            return LockUtils.lock("file:" + file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReadWriteLock getReadWriteLock(String name) {
        Map<String, ReadWriteLock> map = readWriteLocks;
        synchronized (map) {
            ReadWriteLock lock = readWriteLocks.get(name);
            if (lock == null) {
                lock = new UpgradableReadWriteLock(new ReentrantReadWriteLock());
                readWriteLocks.put(name, lock);
            }
            return lock;
        }
    }

    public static Lock lockForRead(String name) {
        ReadWriteLock lock = LockUtils.getReadWriteLock(name);
        lock.readLock().lock();
        return lock.readLock();
    }

    public static Lock lockForWrite(String name) {
        ReadWriteLock lock = LockUtils.getReadWriteLock(name);
        lock.writeLock().lock();
        return lock.writeLock();
    }

    public static Lock lockForRead(File file) {
        try {
            return LockUtils.lockForRead("file:" + file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Lock lockForWrite(File file) {
        try {
            return LockUtils.lockForWrite("file:" + file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

