/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityMutex {
    private Logger logger = LoggerFactory.getLogger(IdentityMutex.class);
    private Object owner;
    private int count;
    private String name;

    public IdentityMutex(String name) {
        this.name = name;
    }

    public synchronized void acquire(Object newOwner) throws InterruptedException {
        this.logger.trace("Acquiring identity mutex (name: {}, owner: {}, count: {}, new owner: {})", new Object[]{this.name, this.owner, this.count, newOwner});
        while (this.count != 0 && !newOwner.equals(this.owner)) {
            this.wait();
        }
        if (this.count == 0) {
            this.owner = newOwner;
            this.count = 1;
        } else {
            ++this.count;
        }
    }

    public synchronized void release() {
        this.logger.trace("Releasing identity mutex (name: {}, owner: {}, count: {})", new Object[]{this.name, this.owner, this.count});
        --this.count;
        if (this.count == 0) {
            this.notifyAll();
        }
    }
}

