/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.util;

import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.hibernate.proxy.HibernateProxy;

public class HibernateUtils {
    private static Properties props;
    public static final String DIALECT = "hibernate.dialect";
    public static final String DRIVER_PROPNAME = "hibernate.connection.driver_class";
    public static final String URL_PROPNAME = "hibernate.connection.url";
    public static final String USER_PROPNAME = "hibernate.connection.username";
    public static final String PASSWORD_PROPNAME = "hibernate.connection.password";

    public static Long getId(AbstractEntity entity) {
        if (entity instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)entity;
            return (Long)proxy.getHibernateLazyInitializer().getIdentifier();
        }
        return entity.getId();
    }

    public static void setId(AbstractEntity entity, Long id) {
        if (entity instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)entity;
            proxy.getHibernateLazyInitializer().setIdentifier((Serializable)id);
        } else {
            entity.setId(id);
        }
    }

    public static synchronized Properties loadProps() {
        if (props == null) {
            String encryptedPassword;
            props = FileUtils.loadProps(new File(Bootstrap.bootDir, "conf/hibernate.properties"));
            String url = props.getProperty(URL_PROPNAME);
            if (url.contains("jdbc:h2:../sampledb/quickbuild")) {
                props.setProperty(URL_PROPNAME, StringUtils.replace((String)url, (String)"..", (String)Bootstrap.installDir.getAbsolutePath()));
            }
            if (StringUtils.isNotBlank((String)(encryptedPassword = props.getProperty("hibernate.connection.encrypted_password")))) {
                props.setProperty(PASSWORD_PROPNAME, StringUtils.decrypt(encryptedPassword.trim()));
            }
        }
        return props;
    }
}

